/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.io.IOException;
import java.nio.file.Path;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSourceChannel;
import org.aksw.commons.io.hadoop.binseach.v2.SeekableReadableChannelSources;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelSource;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;

public class BlockSource
implements SeekableReadableChannelSource<byte[]> {
    protected SeekableReadableChannelSource<byte[]> delegate;
    protected SplittableCompressionCodec codec;

    public BlockSource(SeekableReadableChannelSource<byte[]> delegate, SplittableCompressionCodec codec) {
        this.delegate = delegate;
        this.codec = codec;
    }

    public SeekableReadableChannelSource<byte[]> getDelegate() {
        return this.delegate;
    }

    public long size() throws IOException {
        return this.getDelegate().size();
    }

    public static BlockSource of(Path path, SplittableCompressionCodec codec) {
        return BlockSource.of(SeekableReadableChannelSources.of(path), codec);
    }

    public static BlockSource of(SeekableReadableChannelSource<byte[]> delegate, SplittableCompressionCodec codec) {
        return new BlockSource(delegate, codec);
    }

    public BlockSourceChannel newReadableChannel(long start, long end) throws IOException {
        return this.newReadableChannel(start, end, false);
    }

    public BlockSourceChannel newReadableChannel(long start, long end, boolean blockMode) throws IOException {
        SeekableReadableChannel channel = this.getDelegate().newReadableChannel();
        BlockSourceChannel result = new BlockSourceChannel((SeekableReadableChannel<byte[]>)channel, this.codec, blockMode);
        if (start != 0L) {
            result.position(start);
        }
        return result;
    }

    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    public BlockSourceChannel newReadableChannel(long offset) throws IOException {
        return this.newReadableChannel(offset, Long.MAX_VALUE);
    }

    public BlockSourceChannel newReadableChannel(long offset, boolean blockMode) throws IOException {
        return this.newReadableChannel(offset, Long.MAX_VALUE, blockMode);
    }

    public BlockSourceChannel newReadableChannel() throws IOException {
        return this.newReadableChannel(0L);
    }
}

