/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Supplier;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchLevelCache;
import org.aksw.commons.io.hadoop.binseach.v2.Block;

public class BinSearchResourceCache {
    protected Cache<Object, CacheEntry> resourceCache;
    protected Supplier<CacheEntry> cacheFactory;

    public BinSearchResourceCache(int maxCacheSize) {
        this((Cache<Object, CacheEntry>)Caffeine.newBuilder().maximumSize((long)maxCacheSize).build(), () -> new CacheEntry(BinSearchLevelCache.dftCache(), (Cache<Long, Block>)Caffeine.newBuilder().maximumSize(1000L).build()));
    }

    public BinSearchResourceCache(Cache<Object, CacheEntry> resourceCache, Supplier<CacheEntry> cacheFactory) {
        this.resourceCache = resourceCache;
        this.cacheFactory = cacheFactory;
    }

    public CacheEntry getOrCreate(Object key) {
        return (CacheEntry)this.resourceCache.get(key, k -> this.cacheFactory.get());
    }

    record CacheEntry(BinSearchLevelCache levelCache, Cache<Long, Block> blockCache) {
    }
}

