/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearchBuilder;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;

public class BinSearch {
    public static void main(String[] args) throws IOException {
        byte[] wd;
        Path plainPath = Path.of("/media/raven/T9/raven/datasets/wikidata/2024-08-24_wikidata-truthy.sorted.nt", new String[0]);
        Path bz2Path = Path.of("/media/raven/T9/raven/datasets/wikidata/2024-08-24_wikidata-truthy.sorted.nt.bz2", new String[0]);
        byte[] prefix = "<http://linkedgeodata.org/geometry/node1202810066>".getBytes();
        byte[] first = "<http://linkedgeodata.org/geometry/node1000036734>".getBytes();
        byte[] last = "<http://linkedgeodata.org/triplify/node999596437>".getBytes();
        byte[] lookup = wd = "<http://www.wikidata.org/entity/Q24075>".getBytes();
        BinarySearcher bs = BinarySearchBuilder.newBuilder().setSource(bz2Path).setCodec((SplittableCompressionCodec)new BZip2Codec()).build();
        List<String> tasks = Files.lines(Path.of("/media/raven/T9/raven/datasets/wikidata/movies.nt", new String[0])).map(line -> {
            String[] parts = line.split(" ", 2);
            return parts[0];
        }).toList();
        Stopwatch sw = Stopwatch.createStarted();
        int[] i = new int[]{0};
        tasks.parallelStream().forEach(str -> {
            if (str.contains("<http://www.wikidata.org/entity/Q1001777>")) {
                // empty if block
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(bs.search(str.getBytes()), StandardCharsets.UTF_8));){
                boolean foundMatch;
                boolean bl = foundMatch = br.lines().limit(1L).count() > 0L;
                if (!foundMatch) {
                    System.err.println("NO MATCH FOR: " + str);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing " + str, e);
            }
            int x = i[0] = i[0] + 1;
            if (x % 100 == 0) {
                float elapsed = (float)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001f;
                System.out.println(String.format("Item %d - elapsed: %f, throughput %.2f", x, Float.valueOf(elapsed), Float.valueOf((float)x / elapsed)));
            }
        });
        System.out.println(sw.elapsed(TimeUnit.SECONDS));
    }
}

