/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.bz2;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.PageManagerForFileChannel;
import org.aksw.commons.io.hadoop.binseach.bz2.BinarySearchOnBlockSource;
import org.aksw.commons.io.hadoop.binseach.bz2.BlockSourceBzip2;
import org.aksw.commons.io.seekable.api.SeekableSource;
import org.aksw.commons.io.seekable.impl.SeekableFromBlock;
import org.aksw.commons.io.seekable.impl.SeekableSourceFromPageManager;
import org.aksw.commons.util.ref.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockSources {
    private static final Logger logger = LoggerFactory.getLogger(BlockSources.class);

    public static BinarySearcher createBinarySearcherBz2(Path path) throws IOException {
        return BlockSources.createBinarySearcherBz2(path, 0x1000000);
    }

    public static BinarySearcher createBinarySearcherBz2(Path path, int pageSize) throws IOException {
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        BinarySearcher result = BlockSources.createBinarySearcherBz2(channel, pageSize, true);
        return result;
    }

    public static BinarySearcher createBinarySearcherBz2(FileChannel fileChannel, int pageSize, boolean closeChannel) throws IOException {
        PageManagerForFileChannel pageManager = PageManagerForFileChannel.create((FileChannel)fileChannel, (int)pageSize);
        SeekableSourceFromPageManager pagedSource = new SeekableSourceFromPageManager((PageManager)pageManager);
        BlockSource blockSource = BlockSourceBzip2.create((SeekableSource)pagedSource);
        BinarySearchOnBlockSource result = new BinarySearchOnBlockSource(blockSource, closeChannel ? fileChannel::close : null);
        return result;
    }

    public static BinarySearcher createBinarySearcherBz2(SeekableSource seekableSource) throws IOException {
        BlockSource blockSource = BlockSourceBzip2.create(seekableSource);
        BinarySearchOnBlockSource result = new BinarySearchOnBlockSource(blockSource, null);
        return result;
    }

    public static BinarySearcher createBinarySearcherText(Path path) throws IOException {
        return BlockSources.createBinarySearcherText(path, 0x1000000);
    }

    public static BinarySearcher createBinarySearcherText(Path path, int pageSize) throws IOException {
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        BinarySearcher result = BlockSources.createBinarySearcherText(channel, pageSize, true);
        return result;
    }

    public static BinarySearcher createBinarySearcherText(FileChannel fileChannel, int pageSize, boolean closeChannel) throws IOException {
        PageManagerForFileChannel pageManager = PageManagerForFileChannel.create((FileChannel)fileChannel, (int)pageSize);
        BinarySearchOnBlockSource result = new BinarySearchOnBlockSource((BlockSource)pageManager, closeChannel ? fileChannel::close : null);
        return result;
    }

    public static Ref<? extends Block> binarySearch(BlockSource blockSource, long min, long max, byte delimiter, byte[] prefix) throws IOException {
        Ref<? extends Block> result;
        block23: {
            logger.trace("Binary search in range [" + min + ", " + max + ")");
            if (min >= max) {
                return null;
            }
            long middlePos = min + max >> 1;
            Ref<? extends Block> blockRef = blockSource.contentAtOrBefore(middlePos, true);
            if (blockRef == null) {
                return null;
            }
            Block block = (Block)blockRef.get();
            long pos = block.getOffset();
            if (pos < min) {
                return null;
            }
            try (SeekableFromBlock seekable = new SeekableFromBlock(blockRef.acquire(), 0, 0L);){
                int cmp;
                boolean isNotFirstBlock = block.hasPrev();
                if (isNotFirstBlock) {
                    seekable.posToNext(delimiter);
                    seekable.nextPos(1);
                }
                if ((cmp = seekable.compareToPrefix(prefix)) == 0) {
                    result = blockRef;
                    break block23;
                }
                if (cmp < 0) {
                    try (Ref nextBlockRef = blockSource.contentAtOrAfter(pos, false);){
                        if (nextBlockRef == null) {
                            result = blockRef;
                        } else {
                            long lowerBound = ((Block)nextBlockRef.get()).getOffset();
                            result = BlockSources.binarySearch(blockSource, lowerBound, max, delimiter, prefix);
                            if (result == null) {
                                result = blockRef;
                            } else {
                                BlockSources.closeWithRethrowAsIOException(blockRef);
                            }
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                BlockSources.closeWithRethrowAsIOException((AutoCloseable)blockRef);
                result = BlockSources.binarySearch(blockSource, min, pos, delimiter, prefix);
            }
        }
        return result;
    }

    public static void closeWithRethrowAsIOException(AutoCloseable obj) throws IOException {
        try {
            obj.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

