/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.slice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import org.aksw.commons.util.range.RangeUtils;

public interface SliceMetaData
extends Cloneable {
    public RangeSet<Long> getLoadedRanges();

    public RangeMap<Long, List<Throwable>> getFailedRanges();

    public long getMinimumKnownSize();

    public long getMaximumKnownSize();

    public SliceMetaData setMinimumKnownSize(long var1);

    public SliceMetaData setMaximumKnownSize(long var1);

    public ReadWriteLock getReadWriteLock();

    public Condition getHasDataCondition();

    public int getPageSize();

    default public SliceMetaData updateMaximumKnownSize(long size) {
        long current = this.getMaximumKnownSize();
        if (size < current) {
            this.setMaximumKnownSize(size);
        }
        return this;
    }

    default public SliceMetaData updateMinimumKnownSize(long size) {
        long current = this.getMinimumKnownSize();
        if (size > current) {
            this.setMinimumKnownSize(size);
        }
        return this;
    }

    default public SliceMetaData setKnownSize(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Negative known size");
        this.setMinimumKnownSize(size);
        this.setMaximumKnownSize(size);
        return this;
    }

    default public long getKnownSize() {
        boolean isExact = this.isExactSizeKnown();
        long result = isExact ? this.getMaximumKnownSize() : -1L;
        return result;
    }

    default public RangeSet<Long> getGaps(Range<Long> requestRange) {
        long maxKnownSize = this.getMaximumKnownSize();
        Range maxKnownRange = Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(maxKnownSize));
        Range effectiveRequestRange = requestRange.intersection(maxKnownRange);
        RangeSet<Long> loadedRanges = this.getLoadedRanges();
        RangeSet result = RangeUtils.gaps((Range)effectiveRequestRange, loadedRanges);
        return result;
    }

    default public boolean isExactSizeKnown() {
        long maxSize;
        long minSize = this.getMinimumKnownSize();
        boolean result = minSize == (maxSize = this.getMaximumKnownSize());
        return result;
    }

    default public boolean isComplete() {
        boolean result = false;
        boolean isExactSizeKnown = this.isExactSizeKnown();
        if (isExactSizeKnown) {
            long exactSize = this.getMaximumKnownSize();
            RangeSet<Long> ranges = this.getLoadedRanges();
            Set set = ranges.asRanges();
            if (set.size() == 1) {
                Range range = (Range)set.iterator().next();
                ContiguousSet cs = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.longs());
                Long start = (Long)cs.first();
                Long end = (Long)cs.last();
                result = start != null && end != null && start == 0L && end + 1L == exactSize;
            }
        }
        return result;
    }
}

