/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelDecoratorBase;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.SeekableReadableChannel;

public class SeekableReadableChannelOverReadableChannel<A>
extends ReadableChannelDecoratorBase<A, ReadableChannel<A>>
implements SeekableReadableChannel<A> {
    protected long basePos;
    protected long relPos;
    protected long requestedPos;

    public SeekableReadableChannelOverReadableChannel(ReadableChannel<A> delegate, long basePos) {
        super(delegate);
        this.basePos = basePos;
        this.requestedPos = -1L;
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        int result;
        if (this.requestedPos != -1L) {
            long delta = this.requestedPos - this.basePos;
            if (delta < 0L) {
                throw new IllegalStateException("Requested position is before base offset");
            }
            if (delta > 0L) {
                long n = ReadableChannels.skip((ReadableChannel)this.delegate, delta, array, position, length);
                this.relPos += n;
            }
        }
        if ((result = ((ReadableChannel)this.delegate).read(array, position, length)) > 0) {
            this.relPos += (long)result;
        }
        return result;
    }

    @Override
    public void position(long pos) {
        this.requestedPos = pos;
    }

    @Override
    public SeekableReadableChannel<A> cloneObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.requestedPos >= 0L ? this.requestedPos : this.basePos + this.relPos;
    }
}

