/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.commons.collections.CloseableIterator;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.IteratorOverReadableChannel;
import org.aksw.commons.io.input.ReadableByteChannelAdapter;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelConcat;
import org.aksw.commons.io.input.ReadableChannelDecoratorBase;
import org.aksw.commons.io.input.ReadableChannelOverIterator;
import org.aksw.commons.io.input.ReadableChannelOverNio;
import org.aksw.commons.io.input.ReadableChannelOverReadableSource;
import org.aksw.commons.io.input.ReadableChannelWithCounter;
import org.aksw.commons.io.input.ReadableChannelWithLimit;
import org.aksw.commons.io.input.ReadableChannelWithValue;
import org.aksw.commons.io.input.ReadableSource;
import org.aksw.commons.io.util.channel.ReadableByteChannelFromInputStream;

public class ReadableChannels {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static <A> ReadableChannel<A> limit(ReadableChannel<A> dataStream, long limit) {
        return new ReadableChannelWithLimit(dataStream, limit);
    }

    public static ReadableChannel<byte[]> wrap(ReadableByteChannel channel) {
        return new ReadableChannelOverNio<ReadableByteChannel>(channel);
    }

    public static ReadableChannel<byte[]> wrap(InputStream inputStream) {
        return ReadableChannels.wrap((ReadableByteChannel)new ReadableByteChannelFromInputStream(inputStream));
    }

    public static <T> ReadableChannel<T[]> wrap(Stream<T> stream, ArrayOps<T[]> arrayOps) {
        return ReadableChannels.wrap(stream.iterator(), stream::close, arrayOps);
    }

    public static <T> ReadableChannel<T[]> wrap(Iterator<T> iterator, Runnable closeAction, ArrayOps<T[]> arrayOps) {
        return new ReadableChannelOverIterator<T>(arrayOps, iterator, closeAction);
    }

    public static <T extends ReadableChannel<byte[]>> ReadableByteChannelAdapter<T> newChannel(T dataStream) {
        return new ReadableByteChannelAdapter<T>(dataStream);
    }

    public static InputStream newInputStream(ReadableChannel<byte[]> dataStream) {
        return Channels.newInputStream(ReadableChannels.newChannel(dataStream));
    }

    public static <A> ReadableChannel<A> newChannel(ReadableSource<A> source) {
        return new ReadableChannelOverReadableSource<A>(source);
    }

    public static InputStream newInputStream(ReadableSource<byte[]> source) {
        return ReadableChannels.newInputStream(ReadableChannels.newChannel(source));
    }

    public static <T> CloseableIterator<T> newIterator(ReadableChannel<T[]> dataStream) {
        return ReadableChannels.newIterator(dataStream, 4096);
    }

    public static <T> CloseableIterator<T> newIterator(ReadableChannel<T[]> dataStream, int internalBufferSize) {
        return new IteratorOverReadableChannel(dataStream.getArrayOps(), dataStream, internalBufferSize);
    }

    public static <T> Stream<T> newStream(ReadableChannel<T[]> dataStream) {
        return (Stream)Streams.stream(ReadableChannels.newIterator(dataStream)).onClose(() -> {
            try {
                dataStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <T> Iterator<T> newBoxedIterator(ReadableChannel<?> dataStream) {
        return ReadableChannels.newBoxedIterator(dataStream, 4096);
    }

    public static <T> CloseableIterator<T> newBoxedIterator(ReadableChannel<?> dataStream, int internalBufferSize) {
        return new IteratorOverReadableChannel(dataStream.getArrayOps(), dataStream, internalBufferSize);
    }

    public static <T> Stream<T> newBoxedStream(ReadableChannel<?> dataStream) {
        return ReadableChannels.newBoxedStream(dataStream, 4096);
    }

    public static <T> Stream<T> newBoxedStream(ReadableChannel<?> dataStream, int internalBufferSize) {
        return (Stream)Streams.stream(ReadableChannels.newBoxedIterator(dataStream, internalBufferSize)).onClose(() -> {
            try {
                dataStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <A, X extends ReadableChannel<A>> ReadableChannelWithCounter<A, X> withCounter(X decoratee) {
        return new ReadableChannelWithCounter(decoratee);
    }

    public static <A, T, X extends ReadableChannel<A>> ReadableChannelWithValue<A, T, X> withValue(X decoratee, T value) {
        return new ReadableChannelWithValue(decoratee, value);
    }

    public static <A> ReadableChannel<A> concat(List<ReadableChannel<A>> channels) {
        Preconditions.checkArgument((!channels.isEmpty() ? 1 : 0) != 0);
        return ReadableChannels.concat(channels.get(0).getArrayOps(), channels);
    }

    public static <A> ReadableChannel<A> concat(ArrayOps<A> arrayOps, List<ReadableChannel<A>> channels) {
        return new ReadableChannelConcat<A>(arrayOps, channels);
    }

    public static <A> long skip(ReadableChannel<A> channel, long req, A array, int position, int length) throws IOException {
        int l;
        long result;
        int n;
        if (length == 0) {
            throw new IllegalStateException("Must not be called with length 0");
        }
        for (result = 0L; result < req && (n = channel.read(array, position, l = Ints.saturatedCast((long)Math.min(req - result, (long)length)))) >= 0; result += (long)n) {
        }
        return result;
    }

    public static <A> int readFully(ReadableSource<A> channel, A array, int position, int length) throws IOException {
        int n;
        int result = 0;
        int l = length;
        int p = position;
        while (l > 0 && (n = channel.read(array, p, l)) >= 0) {
            result += n;
            l -= n;
            p += n;
        }
        return result;
    }

    public static <T> ReadableChannel<T> closeShield(ReadableChannel<T> in) {
        Objects.requireNonNull(in);
        return new ReadableChannelDecoratorBase<T, ReadableChannel<T>>(in){

            @Override
            public void close() throws IOException {
            }
        };
    }
}

