/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannelBase;

public class ReadableChannelOverIterator<T>
extends ReadableChannelBase<T[]> {
    protected ArrayOps<T[]> arrayOps;
    protected Iterator<T> iterator = null;
    protected Runnable closeAction;

    public ReadableChannelOverIterator(ArrayOps<T[]> arrayOps, Iterator<T> it, Runnable closeAction) {
        this.arrayOps = arrayOps;
        this.iterator = it;
        this.closeAction = closeAction;
    }

    public void setCloseAction(Runnable closeAction) {
        this.closeAction = closeAction;
    }

    public Stream<T> toStream() {
        return (Stream)Streams.stream(this.iterator).onClose(() -> ((ReadableChannelOverIterator)this).close());
    }

    public Iterator<T> getIterator() {
        return this.iterator;
    }

    public void closeActual() throws IOException {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }

    @Override
    public int read(T[] array, int position, int length) throws IOException {
        int i;
        this.ensureOpen();
        for (i = 0; i < length && this.iterator.hasNext(); ++i) {
            T value = this.iterator.next();
            this.arrayOps.set(array, position + i, value);
        }
        int result = i == 0 && length > 0 ? -1 : i;
        return result;
    }

    @Override
    public ArrayOps<T[]> getArrayOps() {
        return this.arrayOps;
    }
}

