/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelBase;
import org.aksw.commons.util.exception.FinallyRunAll;

public class ReadableChannelConcat<A>
extends ReadableChannelBase<A>
implements ReadableChannel<A> {
    protected ArrayOps<A> arrayOps;
    protected List<ReadableChannel<A>> members;
    protected Iterator<ReadableChannel<A>> it;
    protected ReadableChannel<A> current = null;

    public ReadableChannelConcat(ArrayOps<A> arrayOps, List<ReadableChannel<A>> members) {
        this.arrayOps = arrayOps;
        this.members = members;
        this.it = members.iterator();
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    public void closeActual() {
        FinallyRunAll fra = FinallyRunAll.create();
        for (ReadableChannel<A> member : this.members) {
            fra.addThrowing(member::close);
        }
        fra.addThrowing(() -> super.closeActual());
        fra.run();
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        int n = -1;
        while (true) {
            if (this.current == null) {
                if (!this.it.hasNext()) break;
                this.current = this.it.next();
            }
            if (this.current == null) continue;
            n = this.current.read(array, position, length);
            if (n >= 0) break;
            this.current = null;
        }
        return n;
    }
}

