/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.deprecated;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import org.aksw.commons.io.deprecated.BoyerMooreByteFromWikipedia;
import org.aksw.commons.io.deprecated.BoyerMooreMatcher;
import org.aksw.commons.io.deprecated.MatcherFactory;
import org.aksw.commons.io.deprecated.SeekableMatcher;
import org.aksw.commons.io.seekable.api.Seekable;

public class BoyerMooreMatcherFactory
implements MatcherFactory {
    protected boolean isFwd;
    protected boolean lowerCaseMode;
    protected byte[] pat;
    protected int[] badCharacterTable;
    protected int[] goodSuffixTable;

    public BoyerMooreMatcherFactory(boolean isFwd, boolean lowerCaseMode, byte[] pat, int[] badCharacter, int[] goodSuffix) {
        this.isFwd = isFwd;
        this.lowerCaseMode = lowerCaseMode;
        this.pat = pat;
        this.badCharacterTable = badCharacter;
        this.goodSuffixTable = goodSuffix;
    }

    public static BoyerMooreMatcherFactory createFwd(byte[] pat) {
        return BoyerMooreMatcherFactory.createFwd(pat, false);
    }

    public static BoyerMooreMatcherFactory createFwd(byte[] pat, boolean lowerCaseMode) {
        int[] badCharacterTable = BoyerMooreByteFromWikipedia.createBadCharacterTable(pat);
        int[] goodSuffixTable = BoyerMooreByteFromWikipedia.createGoodSuffixTable(pat);
        return new BoyerMooreMatcherFactory(true, lowerCaseMode, pat, badCharacterTable, goodSuffixTable);
    }

    public static BoyerMooreMatcherFactory createBwd(byte[] pat) {
        return BoyerMooreMatcherFactory.createBwd(pat, false);
    }

    public static BoyerMooreMatcherFactory createBwd(byte[] rawPat, boolean lowerCaseMode) {
        byte[] pat = (byte[])rawPat.clone();
        Bytes.reverse((byte[])pat);
        int[] badCharacterTable = BoyerMooreByteFromWikipedia.createBadCharacterTable(pat);
        int[] goodSuffixTable = BoyerMooreByteFromWikipedia.createGoodSuffixTable(pat);
        return new BoyerMooreMatcherFactory(false, lowerCaseMode, pat, badCharacterTable, goodSuffixTable);
    }

    @Override
    public SeekableMatcher newMatcher() {
        BoyerMooreMatcher result = this.isFwd ? (!this.lowerCaseMode ? new BoyerMooreMatcher(this.isFwd, this.pat, this.badCharacterTable, this.goodSuffixTable) : new BoyerMooreMatcher(this.isFwd, this.pat, this.badCharacterTable, this.goodSuffixTable){

            @Override
            protected byte getByte(Seekable seekable) throws IOException {
                return (byte)Character.toLowerCase(seekable.get());
            }
        }) : (!this.lowerCaseMode ? new BoyerMooreMatcher(this.isFwd, this.pat, this.badCharacterTable, this.goodSuffixTable){

            @Override
            protected boolean nextPos(Seekable seekable, int delta) throws IOException {
                return seekable.prevPos(delta);
            }

            @Override
            protected boolean prevPos(Seekable seekable, int delta) throws IOException {
                return seekable.nextPos(delta);
            }
        } : new BoyerMooreMatcher(this.isFwd, this.pat, this.badCharacterTable, this.goodSuffixTable){

            @Override
            protected boolean nextPos(Seekable seekable, int delta) throws IOException {
                return seekable.prevPos(delta);
            }

            @Override
            protected boolean prevPos(Seekable seekable, int delta) throws IOException {
                return seekable.nextPos(delta);
            }

            @Override
            protected byte getByte(Seekable seekable) throws IOException {
                return (byte)Character.toLowerCase(seekable.get());
            }
        });
        return result;
    }
}

