/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.cache;

import java.time.Duration;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfig;

public class AdvancedRangeCacheConfigImpl
implements AdvancedRangeCacheConfig {
    protected int pageSize;
    protected long maxRequestSize;
    protected Duration terminationDelay;
    protected int internalWorkerSize;
    protected long readBeforeSize;
    protected int maxReadAheadItemCount;

    public AdvancedRangeCacheConfigImpl() {
    }

    public AdvancedRangeCacheConfigImpl(int pageSize, long maxRequestSize, Duration terminationDelay, int internalWorkerSize, int maxReadAheadItemCount) {
        this.pageSize = pageSize;
        this.maxRequestSize = maxRequestSize;
        this.terminationDelay = terminationDelay;
        this.internalWorkerSize = internalWorkerSize;
        this.maxReadAheadItemCount = maxReadAheadItemCount;
    }

    public static AdvancedRangeCacheConfigImpl newDefaultsForObjects() {
        return AdvancedRangeCacheConfigImpl.newDefaultsForObjects(Long.MAX_VALUE);
    }

    public static AdvancedRangeCacheConfigImpl newDefaultsForObjects(long requestSize) {
        return new AdvancedRangeCacheConfigImpl(100000, requestSize, Duration.ofSeconds(5L), 1024, 0);
    }

    public static AdvancedRangeCacheConfigImpl newDefaultForBytes() {
        return AdvancedRangeCacheConfigImpl.newDefaultForBytes(Long.MAX_VALUE);
    }

    public static AdvancedRangeCacheConfigImpl newDefaultForBytes(long requestSize) {
        return new AdvancedRangeCacheConfigImpl(0x1000000, requestSize, Duration.ofSeconds(5L), 8192, 0);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public AdvancedRangeCacheConfigImpl setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public AdvancedRangeCacheConfigImpl setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    @Override
    public Duration getTerminationDelay() {
        return this.terminationDelay;
    }

    public AdvancedRangeCacheConfigImpl setTerminationDelay(Duration terminationDelay) {
        this.terminationDelay = terminationDelay;
        return this;
    }

    @Override
    public int getInternalWorkerSize() {
        return this.internalWorkerSize;
    }

    public void setInternalWorkerSize(int internalWorkerSize) {
        this.internalWorkerSize = internalWorkerSize;
    }

    @Override
    public long getReadBeforeSize() {
        return this.getReadBeforeSize();
    }

    public void setReadBeforeSize(long readBeforeSize) {
        this.readBeforeSize = readBeforeSize;
    }

    @Override
    public int getMaxReadAheadItemCount() {
        return this.maxReadAheadItemCount;
    }

    public void setMaxReadAheadItemCount(int maxReadAheadItemCount) {
        this.maxReadAheadItemCount = maxReadAheadItemCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.internalWorkerSize;
        result = 31 * result + (int)(this.maxRequestSize ^ this.maxRequestSize >>> 32);
        result = 31 * result + this.pageSize;
        result = 31 * result + (int)(this.readBeforeSize ^ this.readBeforeSize >>> 32);
        result = 31 * result + (this.terminationDelay == null ? 0 : this.terminationDelay.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdvancedRangeCacheConfigImpl other = (AdvancedRangeCacheConfigImpl)obj;
        if (this.internalWorkerSize != other.internalWorkerSize) {
            return false;
        }
        if (this.maxRequestSize != other.maxRequestSize) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (this.readBeforeSize != other.readBeforeSize) {
            return false;
        }
        return !(this.terminationDelay == null ? other.terminationDelay != null : !this.terminationDelay.equals(other.terminationDelay));
    }

    public String toString() {
        return "AdvancedRangeCacheConfigImpl [pageSize=" + this.pageSize + ", maxRequestSize=" + this.maxRequestSize + ", terminationDelay=" + String.valueOf(this.terminationDelay) + ", internalWorkerSize=" + this.internalWorkerSize + ", readBeforeSize=" + this.readBeforeSize + "]";
    }
}

