/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.ring;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.ToIntFunction;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.ring.RingBufferBase;
import org.aksw.commons.io.input.ReadableChannels;
import org.apache.commons.io.IOUtils;

public class RingBufferForBytes
extends RingBufferBase<byte[]> {
    public RingBufferForBytes(int size) {
        super(new byte[size]);
    }

    protected RingBufferForBytes(byte[] data, int start, int end, boolean isEmpty) {
        super(data, start, end, isEmpty);
    }

    public byte get(int offset) {
        int pos = this.start + offset;
        if (pos >= this.bufferLen) {
            pos -= this.bufferLen;
        }
        byte result = ((byte[])this.buffer)[pos];
        return result;
    }

    public int read(ByteBuffer out) {
        int length = out.remaining();
        int savedStart = this.start;
        int result = this.preRead(length);
        if (result > 0) {
            out.put((byte[])this.buffer, savedStart, result);
        }
        return result;
    }

    public RingBufferForBytes skip(int length) {
        super.skip(length);
        return this;
    }

    public int append(int maxRemaining, ToIntFunction<ByteBuffer> callback) {
        int cap = this.appendCapacity();
        int len = Math.min(maxRemaining, cap);
        int e = this.end;
        ByteBuffer bb = ByteBuffer.wrap((byte[])this.buffer, e, len);
        int n = callback.applyAsInt(bb);
        this.incEnd(n);
        return n;
    }

    @Override
    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    public RingBufferForBytes shallowClone() {
        return new RingBufferForBytes((byte[])this.buffer, this.start, this.end, this.isEmpty);
    }

    public RingBufferForBytes shallowClone(int customStart, int length) {
        if (length > this.bufferLen) {
            throw new IllegalArgumentException("Length cannot be larger than the buffer");
        }
        boolean customIsEmpty = length == 0;
        int customEnd = customStart + length;
        if (customEnd >= this.bufferLen) {
            customEnd -= this.bufferLen;
        }
        return new RingBufferForBytes((byte[])this.buffer, customStart, customEnd, customIsEmpty);
    }

    public String toString() {
        String result = this.toString(StandardCharsets.UTF_8);
        return result;
    }

    public String toString(Charset charset) {
        String result;
        try (InputStream in = ReadableChannels.newInputStream(ReadableChannels.newChannel(this.shallowClone()));){
            result = IOUtils.toString((InputStream)in, (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

