/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.range;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.math.LongMath;
import java.io.IOException;
import org.aksw.commons.collection.rangeset.RangeSetOps;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.buffer.range.RangeBuffer;
import org.aksw.commons.io.buffer.range.ReadOverGapException;
import org.aksw.commons.util.range.RangeUtils;

public class RangeBufferImpl<A>
implements RangeBuffer<A> {
    protected RangeSet<Long> ranges;
    protected long offsetInRanges;
    protected Buffer<A> backingBuffer;

    public RangeBufferImpl(RangeSet<Long> ranges, long offsetInRanges, Buffer<A> buffer) {
        this.ranges = ranges;
        this.offsetInRanges = offsetInRanges;
        this.backingBuffer = buffer;
    }

    @Override
    public RangeSet<Long> getCoveredRanges(Range<Long> localRange) {
        Range globalRange = RangeUtils.shiftLong(localRange, (long)this.offsetInRanges);
        RangeSet globalCovers = this.ranges.subRangeSet(globalRange);
        RangeSet localCovers = RangeSetOps.shiftLong((RangeSet)globalCovers, (long)(-this.offsetInRanges));
        return localCovers;
    }

    @Override
    public Buffer<A> getBackingBuffer() {
        return this.backingBuffer;
    }

    public static <A> RangeBufferImpl<A> create(RangeSet<Long> ranges, long offsetInRanges, Buffer<A> buffer) {
        return new RangeBufferImpl<A>(ranges, offsetInRanges, buffer);
    }

    public static <A> RangeBufferImpl<A> create(Buffer<A> buffer) {
        return RangeBufferImpl.create((RangeSet<Long>)TreeRangeSet.create(), 0L, buffer);
    }

    public static <A> RangeBufferImpl<A> wrap(Buffer<A> buffer) {
        Range range = Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(buffer.getCapacity()));
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(range);
        return RangeBufferImpl.create((RangeSet<Long>)rangeSet, 0L, buffer);
    }

    @Override
    public RangeSet<Long> getRanges() {
        return this.ranges;
    }

    @Override
    public long getCapacity() {
        return this.backingBuffer.getCapacity();
    }

    @Override
    public Long getOffsetInRanges() {
        return this.offsetInRanges;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.backingBuffer.getArrayOps();
    }

    @Override
    public int readInto(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        long start = srcOffset + this.offsetInRanges;
        long end = start + (long)length;
        Range totalReadRange = Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
        if (!this.ranges.encloses(totalReadRange)) {
            RangeSet gaps = this.ranges.complement().subRangeSet(totalReadRange);
            throw new ReadOverGapException("Attempt to read over gaps at: " + String.valueOf(gaps));
        }
        int result = this.backingBuffer.readInto(tgt, tgtOffset, srcOffset, length);
        return result;
    }

    @Override
    public Object get(long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) throws IOException {
        long start = LongMath.checkedAdd((long)this.offsetInRanges, (long)offsetInBuffer);
        long end = LongMath.checkedAdd((long)start, (long)arrLength);
        if (offsetInBuffer + (long)arrLength > this.backingBuffer.getCapacity()) {
            throw new RuntimeException("Attempt to write beyond buffer capacity");
        }
        this.backingBuffer.write(offsetInBuffer, arrayWithItemsOfTypeT, arrOffset, arrLength);
        this.ranges.add(Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end)));
    }

    @Override
    public void put(long offset, Object item) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getRanges().toString();
    }
}

