/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.plain;

import com.google.common.math.LongMath;
import java.io.IOException;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;

public interface SubBuffer<A>
extends Buffer<A> {
    public Buffer<A> getBackend();

    public long getStart();

    public long getLength();

    @Override
    default public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) throws IOException {
        long length;
        Buffer<A> backend = this.getBackend();
        long start = this.getStart();
        if (offsetInBuffer - start + (long)arrLength > (length = this.getCapacity())) {
            throw new RuntimeException("Attempt to read beyond buffer capacity");
        }
        backend.write(LongMath.checkedAdd((long)start, (long)offsetInBuffer), arrayWithItemsOfTypeT, arrOffset, arrLength);
    }

    @Override
    default public int readInto(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        Buffer<A> backend = this.getBackend();
        long start = this.getStart();
        long subLen = this.getLength();
        long s = LongMath.checkedAdd((long)start, (long)srcOffset);
        long maxLength = srcOffset >= subLen ? 0L : subLen - srcOffset;
        int l = (int)Math.min((long)length, maxLength);
        return backend.readInto(tgt, tgtOffset, s, l);
    }

    @Override
    default public long getCapacity() {
        Buffer<A> backend = this.getBackend();
        long start = this.getStart();
        long length = this.getLength();
        long result = Math.max(0L, Math.min(backend.getCapacity() - start, length));
        return result;
    }

    @Override
    default public ArrayOps<A> getArrayOps() {
        Buffer<A> backend = this.getBackend();
        return backend.getArrayOps();
    }

    @Override
    default public Buffer<A> slice(long offset, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void put(long offset, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Object get(long index) {
        throw new UnsupportedOperationException();
    }
}

