/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.plain;

import com.google.common.math.LongMath;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.util.page.PageUtils;

public class BufferWithPages<A>
implements Buffer<A> {
    protected ArrayOps<A> arrayOps;
    protected int pageSize;
    protected long capacity;
    protected Map<Long, A> map;

    public BufferWithPages(ArrayOps<A> arrayOps, int pageSize) {
        this(arrayOps, pageSize, Long.MAX_VALUE, new HashMap());
    }

    public BufferWithPages(ArrayOps<A> arrayOps, int pageSize, long capacity, Map<Long, A> map) {
        this.arrayOps = arrayOps;
        this.pageSize = pageSize;
        this.capacity = capacity;
        this.map = map;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    public Map<Long, A> getPageMap() {
        return this.map;
    }

    public static <A> BufferWithPages<A> create(ArrayOps<A> arrayOps, int pageSize) {
        return new BufferWithPages<A>(arrayOps, pageSize);
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) {
        if (LongMath.checkedAdd((long)offsetInBuffer, (long)arrLength) > this.capacity) {
            throw new IndexOutOfBoundsException("Put outside of capacity");
        }
        long startPage = PageUtils.getPageIndexForOffset((long)offsetInBuffer, (long)this.pageSize);
        int remainingInSrc = arrLength;
        int indexInPage = PageUtils.getIndexInPage((long)offsetInBuffer, (int)this.pageSize);
        int srcIndex = arrOffset;
        long i = startPage;
        while (remainingInSrc > 0) {
            Object buffer = this.map.computeIfAbsent(i, k -> this.arrayOps.create(this.pageSize));
            int remainingInPage = Math.min(this.pageSize - indexInPage, remainingInSrc);
            this.arrayOps.copyRaw(arrayWithItemsOfTypeT, srcIndex, buffer, indexInPage, remainingInPage);
            srcIndex += remainingInPage;
            remainingInSrc -= remainingInPage;
            indexInPage = 0;
            ++i;
        }
    }

    @Override
    public int readInto(Object tgt, int tgtOffset, long srcOffset, int length) {
        if (LongMath.checkedAdd((long)srcOffset, (long)length) > this.capacity) {
            throw new IndexOutOfBoundsException("Put outside of capacity");
        }
        long startPage = PageUtils.getPageIndexForOffset((long)srcOffset, (long)this.pageSize);
        int remainingInSrc = length;
        int indexInPage = PageUtils.getIndexInPage((long)srcOffset, (int)this.pageSize);
        int tgtIndex = tgtOffset;
        long i = startPage;
        while (remainingInSrc > 0) {
            A buffer = this.map.get(i);
            int remainingInPage = Math.min(this.pageSize - indexInPage, remainingInSrc);
            if (buffer == null) {
                this.arrayOps.fillRaw(tgt, tgtIndex, remainingInPage, null);
            } else {
                this.arrayOps.copyRaw(buffer, indexInPage, tgt, tgtIndex, remainingInPage);
            }
            tgtIndex += remainingInPage;
            remainingInSrc -= remainingInPage;
            indexInPage = 0;
            ++i;
        }
        return length;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public Object get(long index) {
        long page = PageUtils.getPageIndexForOffset((long)index, (long)this.pageSize);
        int indexInPage = PageUtils.getIndexInPage((long)index, (int)this.pageSize);
        A buffer = this.map.get(page);
        Object result = buffer == null ? this.arrayOps.getDefaultValue() : this.arrayOps.get(buffer, indexInPage);
        return result;
    }

    @Override
    public void put(long index, Object item) {
        long page = PageUtils.getPageIndexForOffset((long)index, (long)this.pageSize);
        int indexInPage = PageUtils.getIndexInPage((long)index, (int)this.pageSize);
        Object buffer = this.map.computeIfAbsent(page, x -> this.arrayOps.create(this.pageSize));
        this.arrayOps.set(buffer, indexInPage, item);
    }
}

