/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.array;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.ThreadSafe;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.array.ArraySink;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.buffer.plain.SubBuffer;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSwitchable;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannels;
import org.aksw.commons.io.shared.ChannelBase;
import org.apache.commons.io.input.BoundedInputStream;

@ThreadSafe
public class BufferOverReadableChannel<A>
implements Buffer<A> {
    protected A[] buckets;
    protected ArrayOps<A> arrayOps;
    protected BucketPointer activeEnd;
    protected long knownDataSize = 0L;
    protected ReadableChannel<A> dataSupplier;
    protected boolean isDataSupplierConsumed = false;
    protected int minReadSize;
    protected int maxReadSize;
    protected Buffer<A> bufferView = new BufferView();

    public long getKnownDataSize() {
        return this.knownDataSize;
    }

    public Buffer<A> getBuffer() {
        return this.bufferView;
    }

    public ReadableChannel<A> getDataSupplier() {
        return this.dataSupplier;
    }

    public void setDataSupplier(ReadableChannel<A> dataSupplier) {
        this.dataSupplier = dataSupplier;
        this.isDataSupplierConsumed = dataSupplier == null;
    }

    public static <A> long getPosition(ArrayOps<A> arrayOps, A[] buckets, int idx, int pos) {
        long result = 0L;
        for (int i = 0; i < idx; ++i) {
            result += (long)arrayOps.length(buckets[i]);
        }
        return result += (long)pos;
    }

    public static <A> BucketPointer getPointer(ArrayOps<A> arrayOps, A[] buckets, BucketPointer end, long pos) {
        A bucket;
        int i;
        int n;
        long tmp = pos;
        int eidx = end.bucketIdx;
        int epos = end.itemIdx;
        for (i = 0; i < eidx && (long)(n = arrayOps.length(bucket = buckets[i])) <= tmp; tmp -= (long)n, ++i) {
        }
        BucketPointer result = i == end.bucketIdx && tmp > (long)epos ? null : new BucketPointer(i, Ints.checkedCast((long)tmp));
        return result;
    }

    public static <A> BucketPointer getPointerRel(ArrayOps<A> arrayOps, A[] buckets, BucketPointer end, long startPos, BucketPointer startPtr, long pos) {
        BucketPointer result;
        long delta;
        Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0, (Object)"Encountered negative position");
        int i = startPtr.bucketIdx;
        int p = startPtr.itemIdx;
        if (delta > 0L) {
            A bucket;
            int n;
            int a;
            int eidx = end.bucketIdx;
            int epos = end.itemIdx;
            for (delta = pos - startPos; i < eidx && delta >= (long)(a = (n = arrayOps.length(bucket = buckets[i])) - p); delta -= (long)a, ++i) {
                p = 0;
            }
            p = (int)((long)p + delta);
            result = i == eidx && p > epos ? null : new BucketPointer(i, p);
        } else if (delta < 0L) {
            delta = -delta;
            while (true) {
                if (delta <= (long)p) break;
                delta -= (long)p;
                if (--i < 0) {
                    throw new IllegalStateException("Should never happen");
                }
                A bucket = buckets[i];
                p = arrayOps.length(bucket);
            }
            p = (int)((long)p - delta);
            result = new BucketPointer(i, p);
        } else {
            result = startPtr;
        }
        return result;
    }

    public BufferOverReadableChannel(ArrayOps<A> arrayOps, int initialBucketSize, ReadableChannel<A> dataSupplier, int minReadSize) {
        if (initialBucketSize <= 0) {
            throw new IllegalArgumentException("Bucket size must not be 0");
        }
        this.arrayOps = arrayOps;
        this.buckets = new Object[8];
        this.buckets[0] = arrayOps.create(initialBucketSize);
        this.minReadSize = minReadSize;
        this.maxReadSize = minReadSize;
        this.activeEnd = new BucketPointer(0, 0);
        this.dataSupplier = dataSupplier;
        this.isDataSupplierConsumed = dataSupplier == null;
    }

    public boolean isDataSupplierConsumed() {
        return this.isDataSupplierConsumed;
    }

    protected int nextBucketSize() {
        long activeSize = this.arrayOps.length(this.buckets[this.activeEnd.bucketIdx]);
        int maxBucketSize = 0x3FFFFFFF;
        int nextSize = Math.min(Ints.saturatedCast((long)(activeSize * 2L)), maxBucketSize);
        return nextSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doRead(ArraySink<A> dst, Channel reader) {
        int result = 0;
        BucketPointer pointer = reader.pointer;
        long requestedPos = reader.requestedPos;
        if (requestedPos >= 0L) {
            BucketPointer end = this.activeEnd;
            pointer = BufferOverReadableChannel.getPointerRel(this.arrayOps, this.buckets, end, reader.pos, reader.pointer, requestedPos);
            if (pointer == null) {
                if (this.isDataSupplierConsumed) {
                    return -1;
                }
                this.loadDataUpTo(requestedPos);
                end = this.activeEnd;
                pointer = BufferOverReadableChannel.getPointerRel(this.arrayOps, this.buckets, end, reader.pos, reader.pointer, requestedPos);
                if (pointer == null) {
                    if (this.isDataSupplierConsumed) {
                        return -1;
                    }
                    throw new IllegalStateException("Should not happen: Could not map pointer position despite all data known");
                }
            }
            Objects.requireNonNull(pointer);
            reader.pointer = pointer;
            reader.pos = reader.requestedPos;
            reader.requestedPos = -1L;
        }
        int bucketIdx = pointer.bucketIdx;
        int bucketPos = pointer.itemIdx;
        while (true) {
            int remainingBucketLen;
            int remainingDstLen;
            if ((remainingDstLen = dst.remaining()) == 0) {
                if (result != 0) break;
                result = -1;
                break;
            }
            A currentBucket = this.buckets[bucketIdx];
            BucketPointer end = this.activeEnd;
            boolean isInLastBucket = bucketIdx == end.bucketIdx;
            int n = remainingBucketLen = isInLastBucket ? end.itemIdx - bucketPos : this.arrayOps.length(currentBucket) - bucketPos;
            if (remainingBucketLen == 0) {
                if (isInLastBucket) {
                    if (result != 0) break;
                    if (!this.isDataSupplierConsumed) {
                        BufferOverReadableChannel bufferOverReadableChannel = this;
                        synchronized (bufferOverReadableChannel) {
                            if (bucketPos == end.itemIdx && bucketIdx == end.bucketIdx && !this.isDataSupplierConsumed) {
                                this.loadData(dst.limit(), false);
                                continue;
                            }
                        }
                    } else {
                        result = -1;
                    }
                } else {
                    ++bucketIdx;
                    bucketPos = 0;
                    continue;
                }
            }
            int n2 = Math.min(remainingDstLen, remainingBucketLen);
            dst.put(currentBucket, bucketPos, n2);
            result += n2;
            pointer.itemIdx = bucketPos += n2;
            reader.pos += (long)n2;
            pointer.bucketIdx = bucketIdx;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataUpTo(long requestedPos) {
        while (!this.isDataSupplierConsumed && this.knownDataSize <= requestedPos) {
            BufferOverReadableChannel bufferOverReadableChannel = this;
            synchronized (bufferOverReadableChannel) {
                if (!this.isDataSupplierConsumed && this.knownDataSize <= requestedPos) {
                    int needed = Ints.saturatedCast((long)(requestedPos - this.knownDataSize));
                    this.loadData(needed, false);
                }
            }
        }
    }

    public void truncate() {
        this.activeEnd.bucketIdx = 0;
        this.activeEnd.itemIdx = 0;
        this.knownDataSize = 0L;
    }

    public int loadFully(int amount, boolean exact) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0);
        int result = -1;
        if (!this.isDataSupplierConsumed) {
            int n;
            for (int remaining = amount; remaining > 0 && (n = this.loadData(remaining, exact)) >= 0; remaining -= n) {
                result += n;
            }
        }
        return result;
    }

    protected int loadData(int needed, boolean exact) {
        int n = -1;
        if (!this.isDataSupplierConsumed) {
            this.ensureCapacityInActiveBucket();
            A activeBucket = this.buckets[this.activeEnd.bucketIdx];
            int len = Math.min(needed, this.maxReadSize);
            if (!exact) {
                len = Math.max(len, this.minReadSize);
            }
            if ((len = Math.min(len, this.arrayOps.length(activeBucket) - this.activeEnd.itemIdx)) != 0) {
                try {
                    n = this.dataSupplier.read(activeBucket, this.activeEnd.itemIdx, len);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (n > 0) {
                    this.activeEnd.itemIdx += n;
                    this.knownDataSize += (long)n;
                } else if (n == -1) {
                    this.isDataSupplierConsumed = true;
                } else {
                    if (n == 0) {
                        throw new IllegalStateException("Data supplier returned 0 bytes");
                    }
                    throw new IllegalStateException("Invalid return value: " + n);
                }
            }
        }
        return n;
    }

    protected void ensureCapacityInActiveBucket() {
        A activeBucket = this.buckets[this.activeEnd.bucketIdx];
        int capacity = this.arrayOps.length(activeBucket) - this.activeEnd.itemIdx;
        if (capacity == 0) {
            int nextBucketSize = this.nextBucketSize();
            if (nextBucketSize == 0) {
                throw new IllegalStateException("Bucket of size 0 generated");
            }
            int newEndIdx = this.activeEnd.bucketIdx + 1;
            if (newEndIdx >= this.buckets.length) {
                int numNewBuckets = Ints.saturatedCast((long)(this.buckets.length * 2));
                Object[] newBuckets = new Object[numNewBuckets];
                System.arraycopy(this.buckets, 0, newBuckets, 0, this.buckets.length);
                this.buckets = newBuckets;
            }
            this.buckets[newEndIdx] = this.arrayOps.create(nextBucketSize);
            this.activeEnd = new BucketPointer(newEndIdx, 0);
        }
    }

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public void write(long offsetInBuffer, ReadableChannel<A> source, int amount) throws IOException {
        BucketPointer pointer;
        if (offsetInBuffer == this.knownDataSize) {
            pointer = this.activeEnd;
        } else if (offsetInBuffer < this.knownDataSize) {
            pointer = BufferOverReadableChannel.getPointer(this.arrayOps, this.buckets, this.activeEnd, offsetInBuffer);
        } else {
            throw new UnsupportedOperationException("Appending data past the end not yet supported");
        }
        int remainingInputLen = amount;
        while (true) {
            int remainingBucketLen;
            int readLen;
            A bucket;
            int n;
            if (pointer.bucketIdx == this.activeEnd.bucketIdx) {
                this.ensureCapacityInActiveBucket();
            }
            if ((n = source.read(bucket = this.buckets[pointer.bucketIdx], pointer.itemIdx, readLen = Math.min(remainingInputLen, remainingBucketLen = this.arrayOps.length(bucket) - pointer.itemIdx))) < 0 || (remainingInputLen -= n) <= 0) break;
            ++pointer.bucketIdx;
            pointer.itemIdx = 0;
        }
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) throws IOException {
        this.write(offsetInBuffer, SeekableReadableChannels.of(this.arrayOps, arrayWithItemsOfTypeT, arrOffset), arrLength);
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    @Override
    public int readInto(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        int result;
        try (Channel channel = new Channel(this, false, 0L, new BucketPointer(0, 0), srcOffset);){
            result = channel.read(tgt, tgtOffset, length);
        }
        return result;
    }

    @Override
    public SeekableReadableChannel<A> newReadableChannel() throws IOException {
        return new Channel(this, true, 0L, new BucketPointer(0, 0), -1L);
    }

    public static <T> BufferOverReadableChannel<T[]> createForObjects(int initialCapacity) {
        ArrayOps<T[]> arrayOps = ArrayOps.forObjects();
        return new BufferOverReadableChannel<T[]>(arrayOps, initialCapacity, null, 1);
    }

    public static BufferOverReadableChannel<byte[]> createForBytes() {
        return BufferOverReadableChannel.createForBytes(InputStream.nullInputStream());
    }

    public static BufferOverReadableChannel<byte[]> createForBytes(InputStream in) {
        return BufferOverReadableChannel.createForBytes(in, 8192);
    }

    public static BufferOverReadableChannel<byte[]> createForBytes(InputStream in, int minReadSize) {
        ReadableChannel<byte[]> channel = ReadableChannels.wrap(in);
        return BufferOverReadableChannel.createForBytes(channel, minReadSize);
    }

    public static BufferOverReadableChannel<byte[]> createForBytes(ReadableChannel<byte[]> channel, int minReadSize) {
        return new BufferOverReadableChannel<byte[]>(ArrayOps.BYTE, 8, channel, minReadSize);
    }

    public static void main(String[] args) throws IOException {
        Random random = new Random();
        Path path = Path.of("/tmp/test.ttl", new String[0]);
        try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);
             InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            BufferOverReadableChannel<byte[]> buffer = BufferOverReadableChannel.createForBytes(in);
            long size = fc.size();
            System.out.println("Size:" + size);
            for (int i = 0; i < 50000; ++i) {
                byte actual;
                long pos = Math.abs(random.nextLong()) % size;
                System.out.println(String.format("Iteration %d, pos %d", i, pos %= Integer.MAX_VALUE));
                fc.position(pos);
                ByteBuffer bb = ByteBuffer.allocate(1);
                fc.read(bb);
                byte expected = bb.get(0);
                try (ReadableChannel bc = buffer.newReadableChannel();){
                    byte[] b = new byte[1];
                    bc.position(pos);
                    bc.read(b, 0, 1);
                    bc.position(pos);
                    try (SeekableReadableChannel<byte[]> bc2 = bc.cloneObject();){
                        CharSequence cs = SeekableReadableChannels.asCharSequence(bc2, Ints.saturatedCast((long)size));
                        actual = (byte)cs.charAt(Ints.checkedCast((long)pos));
                    }
                }
                if (expected == actual) continue;
                throw new RuntimeException("Results differ at position " + pos);
            }
        }
    }

    public static void main2(String[] args) throws IOException {
        byte[] dst = new byte[4096];
        long r = 0L;
        for (int i = 0; i < 10; ++i) {
            Stopwatch sw = Stopwatch.createStarted();
            BoundedInputStream in = new BoundedInputStream(Files.newInputStream(Path.of("/tmp/test.ttl", new String[0]), new OpenOption[0]), 2147482647L);
            BufferOverReadableChannel<byte[]> bufferedChannel = null;
            bufferedChannel = BufferOverReadableChannel.createForBytes((InputStream)in);
            ReadableChannel channel = bufferedChannel.newReadableChannel();
            Hasher hasher = Hashing.sha256().newHasher();
            ByteStreams.copy((InputStream)ReadableChannels.newInputStream(channel), (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
            String hash = hasher.hash().toString();
            System.out.println("Hash: " + hash);
            if (bufferedChannel != null) {
                hasher = Hashing.sha256().newHasher();
                Buffer<byte[]> memBuffer = bufferedChannel.getBuffer();
                channel = memBuffer.newReadableChannel();
                ByteStreams.copy((InputStream)ReadableChannels.newInputStream(channel), (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                String hash2 = hasher.hash().toString();
                System.out.println("Hash2: " + hash2);
            }
            System.out.println("Bytes read on interation " + i + " " + r + " " + (float)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001f);
            channel.close();
        }
    }

    public static <A> ReadableChannelSwitchable<A> newBufferedChannel(BufferOverReadableChannel<A> buffer) {
        ReadableChannel channel;
        try {
            channel = buffer.newReadableChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ReadableChannelSwitchable(channel);
    }

    public static <A> void debuffer(ReadableChannel<A> channel) {
        ReadableChannelSwitchable switchable = (ReadableChannelSwitchable)channel;
        Channel core = (Channel)switchable.getDelegate();
        Lock writeLock = switchable.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            BufferOverReadableChannel borc = core.getOwner();
            Buffer buffer = borc.getBuffer();
            long bufferSize = buffer.size();
            long pos = core.position();
            ReadableChannel dataSupplier = borc.getDataSupplier();
            ReadableChannel newChannel = pos < bufferSize ? ReadableChannels.concat(Arrays.asList(buffer.newReadableChannel(pos), dataSupplier)) : dataSupplier;
            switchable.setDecoratee(newChannel);
            core.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static class BucketPointer
    implements Comparable<BucketPointer> {
        int bucketIdx;
        int itemIdx;

        public BucketPointer(int bucketIdx, int itemIdx) {
            this.bucketIdx = bucketIdx;
            this.itemIdx = itemIdx;
        }

        public BucketPointer cloneObject() {
            return new BucketPointer(this.bucketIdx, this.itemIdx);
        }

        public String toString() {
            return "BucketPointer [buckedIdx=" + this.bucketIdx + ", itemIdx=" + this.itemIdx + "]";
        }

        @Override
        public int compareTo(BucketPointer o) {
            int result = o.bucketIdx - this.itemIdx;
            if (result == 0) {
                result = o.itemIdx - this.itemIdx;
            }
            return result;
        }
    }

    protected class BufferView
    implements SubBuffer<A> {
        protected BufferView() {
        }

        @Override
        public Buffer<A> getBackend() {
            return BufferOverReadableChannel.this;
        }

        @Override
        public long getStart() {
            return 0L;
        }

        @Override
        public long getLength() {
            return BufferOverReadableChannel.this.knownDataSize;
        }

        @Override
        public long size() throws IOException {
            return this.getLength();
        }
    }

    public static class Channel<A>
    extends ChannelBase
    implements SeekableReadableChannel<A> {
        protected BufferOverReadableChannel<A> owner;
        protected BucketPointer pointer;
        protected long pos;
        protected long requestedPos = -1L;

        public BufferOverReadableChannel<A> getOwner() {
            return this.owner;
        }

        public Channel(BufferOverReadableChannel<A> owner, boolean enableInitializationStackTrace, long pos, BucketPointer pointer, long requestedPos) {
            super(enableInitializationStackTrace);
            this.owner = owner;
            this.pointer = pointer;
            this.pos = pos;
            this.requestedPos = requestedPos;
        }

        @Override
        public ArrayOps<A> getArrayOps() {
            return this.owner.arrayOps;
        }

        @Override
        public int read(A array, int position, int length) throws IOException {
            this.ensureOpen();
            ArraySink.ArraySinkArray sink = new ArraySink.ArraySinkArray(this.owner.arrayOps, array, position, position + length);
            int result = this.owner.doRead(sink, this);
            return result;
        }

        @Override
        public long position() {
            return this.requestedPos >= 0L ? this.requestedPos : this.pos;
        }

        @Override
        public void position(long pos) {
            this.requestedPos = pos;
        }

        @Override
        public SeekableReadableChannel<A> cloneObject() {
            Channel<A> result = new Channel<A>(this.owner, true, this.pos, this.pointer.cloneObject(), this.requestedPos);
            return result;
        }
    }
}

