/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.impl;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.Page;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;
import org.aksw.commons.util.ref.Ref;

public class PageNavigator
extends AutoCloseableWithLeakDetectionBase
implements Seekable {
    protected PageManager pageManager;
    protected int pageSize;
    protected long page = 0L;
    protected int index = 0;
    protected Ref<? extends Page> pageObj = null;
    protected ByteBuffer pageBuffer = null;
    protected int displacement;
    protected long bufferForPage = -1L;
    protected int absMaxIndexInPage;
    protected int absMinIndexInPage;
    protected int relMinIndexInPage;
    protected int relMaxIndexInPage;
    protected long minPos;
    protected long minPage;
    protected int minIndex;
    protected long maxPos;
    protected long maxPage;
    protected int maxIndex;

    public PageNavigator(PageManager pageManager) {
        this(pageManager, 0L, pageManager.getEndPos());
    }

    @Override
    public synchronized PageNavigator clone() {
        PageNavigator result = new PageNavigator(this.pageManager, this.minPos, this.maxPos);
        result.page = this.page;
        result.index = this.index;
        result.pageObj = this.pageObj == null ? null : this.pageObj.acquire((Object)"clone");
        result.pageBuffer = result.pageObj == null ? null : ((Page)result.pageObj.get()).newBuffer();
        result.displacement = this.displacement;
        result.bufferForPage = this.bufferForPage;
        result.absMaxIndexInPage = this.absMaxIndexInPage;
        result.absMinIndexInPage = this.absMaxIndexInPage;
        result.relMinIndexInPage = this.relMinIndexInPage;
        result.relMaxIndexInPage = this.relMaxIndexInPage;
        result.minPos = this.minPos;
        result.minPage = this.minPage;
        result.minIndex = this.minIndex;
        result.maxPos = this.maxPos;
        result.maxPage = this.maxPage;
        result.maxIndex = this.maxIndex;
        return result;
    }

    public PageNavigator(PageManager pageManager, long minPos, long maxPos) {
        if (minPos > maxPos) {
            throw new IndexOutOfBoundsException("min pos must not exceed max " + minPos + " " + maxPos);
        }
        long endPos = pageManager.getEndPos();
        minPos = Math.min(minPos, endPos);
        maxPos = Math.min(maxPos, endPos);
        this.pageManager = pageManager;
        this.pageSize = pageManager.getPageSize();
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.minPage = this.getPageForPos(minPos);
        this.minIndex = this.getIndexForPos(minPos);
        this.maxPage = this.getPageForPos(maxPos);
        this.maxIndex = this.getIndexForPos(maxPos);
        this.updateRelCache(this.page);
    }

    public PageNavigator limitNext(long length) {
        long pos = this.getPos();
        long targetPos = pos + length;
        this.maxPos = Math.min(this.maxPos, targetPos);
        this.maxPage = this.getPageForPos(this.maxPos);
        this.maxIndex = this.getIndexForPos(this.maxPos);
        this.updateRelCache(this.page);
        if (pos > targetPos) {
            this.posToEnd();
        }
        return this;
    }

    public PageNavigator limitPrev(long length) {
        long pos = this.getPos();
        long targetPos = pos - length;
        this.minPos = Math.max(this.minPos, targetPos);
        this.minPage = this.getPageForPos(this.minPos);
        this.minIndex = this.getIndexForPos(this.minPos);
        this.updateRelCache(this.page);
        if (pos < targetPos) {
            this.posToStart();
        }
        return this;
    }

    @Override
    public long getPos() {
        long result = this.page * (long)this.pageSize + (long)this.index;
        return result;
    }

    @Override
    public boolean isPosAfterEnd() {
        boolean result = this.page > this.maxPage || this.page == this.maxPage && this.index >= this.maxIndex;
        return result;
    }

    @Override
    public boolean isPosBeforeStart() {
        boolean result = this.page < this.minPage || this.page == this.minPage && this.index < this.minIndex;
        return result;
    }

    public ByteBuffer getBufferForPage(long page) throws IOException {
        if (page == this.bufferForPage) {
            return this.pageBuffer;
        }
        if (page < this.minPage || page > this.maxPage) {
            return null;
        }
        if (this.pageObj != null) {
            try {
                this.pageObj.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.pageObj = this.pageManager.requestBufferForPage(page);
        ByteBuffer buf = ((Page)this.pageObj.get()).newBuffer();
        if (buf != null) {
            this.pageBuffer = buf;
            this.bufferForPage = page;
            this.displacement = buf.position();
        } else {
            this.displacement = 0;
        }
        this.updateRelCache(page);
        this.absMinIndexInPage = this.displacement + this.relMinIndexInPage;
        this.absMaxIndexInPage = this.displacement + this.relMaxIndexInPage;
        return buf;
    }

    public void updateRelCache(long page) {
        this.relMinIndexInPage = this.getRelMinIndex(page);
        this.relMaxIndexInPage = this.getRelMaxIndex(page);
    }

    public int getRelMaxIndex(long page) {
        int result = page < this.maxPage ? this.pageSize : (page == this.maxPage ? this.maxIndex : 0);
        return result;
    }

    public int getRelMinIndex(long page) {
        int result = page > this.minPage ? 0 : (page == this.minPage ? this.minIndex : this.pageSize - 1);
        return result;
    }

    public ByteBuffer getBufferForPos(long pos) throws IOException {
        long page = this.getPageForPos(pos);
        ByteBuffer result = this.getBufferForPage(page);
        return result;
    }

    public long getPageForPos(long pos) {
        long result = this.pageSize == 0 ? 0L : pos / (long)this.pageSize;
        return result;
    }

    public int getIndexForPos(long pos) {
        int result = this.pageSize == 0 ? 0 : (int)(pos % (long)this.pageSize);
        return result;
    }

    @Override
    public void posToStart() {
        this.setPos(this.minPage, this.minIndex - 1);
    }

    @Override
    public void posToEnd() {
        this.setPos(this.maxPage, this.maxIndex);
    }

    public void setPos(long page, int index) {
        this.page = page;
        this.index = index;
        this.updateRelCache(page);
    }

    @Override
    public void setPos(long pos) {
        this.page = this.getPageForPos(pos);
        this.index = this.getIndexForPos(pos);
        this.setPos(this.page, this.index);
    }

    public long getMinPos() {
        return this.minPos;
    }

    public long getMaxPos() {
        return this.maxPos;
    }

    @Override
    public byte get() throws IOException {
        ByteBuffer buf = this.getBufferForPage(this.page);
        byte result = buf.get(this.displacement + this.index);
        return result;
    }

    public boolean canNextPos() {
        if (this.index + 1 < this.relMaxIndexInPage) {
            return true;
        }
        int nextRelMaxIndex = this.getRelMaxIndex(this.page + 1L);
        boolean result = nextRelMaxIndex > 0;
        return result;
    }

    public boolean canPrevPos() {
        if (this.index - 1 >= this.relMinIndexInPage) {
            return true;
        }
        int nextRelMinIndex = this.getRelMinIndex(this.page - 1L);
        boolean result = nextRelMinIndex < this.pageSize - 1;
        return result;
    }

    @Override
    public int checkNext(int len, boolean changePos) throws IOException {
        long pos = this.getPos();
        int r = Math.min(Ints.saturatedCast((long)(this.maxPos - pos)), len);
        if (changePos) {
            this.nextPos(r);
        }
        return r;
    }

    @Override
    public int checkPrev(int len, boolean changePos) throws IOException {
        long pos = this.getPos();
        int r = Math.min(Ints.saturatedCast((long)(pos - this.minPos)), len);
        if (changePos) {
            this.prevPos(r);
        }
        return r;
    }

    @Override
    public boolean nextPos(int delta) throws IOException {
        int tgtIndex;
        long tgtPage;
        boolean simpleDelta;
        int nextIndex = this.index + delta;
        if (nextIndex < this.relMaxIndexInPage) {
            this.index = nextIndex;
            return true;
        }
        boolean bl = simpleDelta = delta < this.pageSize;
        if (simpleDelta) {
            tgtPage = this.page + 1L;
            tgtIndex = nextIndex - this.relMaxIndexInPage;
        } else {
            long p = this.getPos() + (long)delta;
            tgtPage = this.getPageForPos(p);
            tgtIndex = this.getIndexForPos(p);
        }
        ByteBuffer buf = this.getBufferForPage(tgtPage);
        if (buf != null) {
            this.page = tgtPage;
            this.index = tgtIndex;
            this.setPos(this.page, this.index);
            return true;
        }
        return false;
    }

    @Override
    public boolean prevPos(int delta) throws IOException {
        int tgtIndex;
        long tgtPage;
        boolean simpleDelta;
        int prevIndex = this.index - delta;
        if (prevIndex >= this.relMinIndexInPage) {
            this.index = prevIndex;
            return true;
        }
        boolean bl = simpleDelta = delta < this.pageSize;
        if (simpleDelta) {
            tgtPage = this.page - 1L;
            tgtIndex = this.pageSize - (this.relMinIndexInPage - prevIndex);
        } else {
            long p = this.getPos() - (long)delta;
            tgtPage = this.getPageForPos(p);
            tgtIndex = this.getIndexForPos(p);
        }
        ByteBuffer buf = this.getBufferForPage(tgtPage);
        if (buf != null) {
            this.page = tgtPage;
            this.index = tgtIndex;
            this.setPos(this.page, this.index);
            return true;
        }
        return false;
    }

    @Override
    public boolean posToNext(byte delimiter) throws IOException {
        ByteBuffer buffer;
        long p = this.page;
        int i = this.index;
        block0: while ((buffer = this.getBufferForPage(p)) != null) {
            int absGetIndexInPage;
            for (absGetIndexInPage = this.displacement + i; absGetIndexInPage < this.absMaxIndexInPage; ++absGetIndexInPage) {
                byte a = buffer.get(absGetIndexInPage);
                if (a != delimiter) continue;
                i = absGetIndexInPage - this.displacement;
                break block0;
            }
            if (p == this.maxPage) {
                i = absGetIndexInPage - this.displacement;
                if (i != this.pageSize) break;
                i = 0;
                ++p;
                break;
            }
            i = 0;
            ++p;
        }
        if (i != this.index || p != this.page) {
            this.setPos(p, i);
            return true;
        }
        return false;
    }

    @Override
    public boolean posToPrev(byte delimiter) throws IOException {
        ByteBuffer buffer;
        long p = this.page;
        int i = this.index;
        block0: while ((buffer = this.getBufferForPage(p)) != null) {
            int absGetIndexInPage;
            for (absGetIndexInPage = this.displacement + i; absGetIndexInPage >= this.absMinIndexInPage; --absGetIndexInPage) {
                byte c = buffer.get(absGetIndexInPage);
                if (c != delimiter) continue;
                i = absGetIndexInPage - this.displacement;
                break block0;
            }
            if (p == this.minPage) {
                i = absGetIndexInPage - this.displacement;
                if (i != -1) break;
                i = this.pageSize - 1;
                --p;
                break;
            }
            i = this.pageSize - 1;
            --p;
        }
        if (i != this.index || p != this.page) {
            this.setPos(p, i);
            return true;
        }
        return false;
    }

    public long getNextPosFor(byte delimiter) throws IOException {
        ByteBuffer buffer;
        int i = this.index;
        long p = this.page;
        block0: while ((buffer = this.getBufferForPage(p)) != null) {
            int o = buffer.position();
            int r = buffer.remaining();
            for (i = this.index; i < r; ++i) {
                byte a = buffer.get(o + i);
                if (a == delimiter) break block0;
            }
            this.index = 0;
            ++p;
        }
        long result = (this.pageBuffer == null ? p - 1L : p) * (long)this.pageSize + (long)i;
        return result;
    }

    public long getPrevPosFor(byte delimiter) throws IOException {
        long p;
        int i = this.index;
        block0: for (p = this.page; p >= 0L; --p) {
            ByteBuffer buffer = this.getBufferForPage(p);
            int o = buffer.position();
            for (i = this.index; i >= 0; --i) {
                byte c = buffer.get(o + i);
                if (c == delimiter) break block0;
            }
            this.index = this.pageSize - 1;
        }
        p = Math.max(0L, p);
        long result = p * (long)this.pageSize + (long)i;
        return result;
    }

    @Override
    public int compareToPrefix(byte[] prefix) throws IOException {
        ByteBuffer buffer;
        int x = 0;
        int n = prefix.length;
        int result = 0;
        long p = this.page;
        int i = this.index;
        block0: while ((buffer = this.getBufferForPage(p)) != null) {
            for (int absGetIndexInPage = this.displacement + i; absGetIndexInPage < this.absMaxIndexInPage && x < n; ++absGetIndexInPage, ++x) {
                byte b;
                byte a = buffer.get(absGetIndexInPage);
                result = Byte.compare(a, b = prefix[x]);
                if (result != 0) break block0;
            }
            if (x == n) break;
            if (p == this.maxPage) {
                result = -1;
                break;
            }
            i = 0;
            ++p;
        }
        this.getBufferForPage(p);
        return result;
    }

    @Override
    public int peekNextBytes(byte[] dst, int offset, int len) throws IOException {
        ByteBuffer buffer;
        int x = 0;
        int delta = this.index;
        long p = this.page;
        while (x < len && (buffer = this.getBufferForPage(p)) != null) {
            int absMaxIndexInPage = buffer.limit();
            for (int i = this.displacement + delta; i < absMaxIndexInPage && x < len; ++i, ++x) {
                byte b;
                dst[offset + x] = b = buffer.get(i);
            }
            delta = 0;
            ++p;
        }
        return x;
    }

    public String readLine() throws IOException {
        long start = this.getPos();
        this.posToNext((byte)10);
        long end = this.getPos();
        this.setPos(start);
        int len = (int)(end - start);
        byte[] arr = new byte[len];
        this.peekNextBytes(arr, 0, len);
        String result = new String(arr);
        return result;
    }

    @Override
    public String readString(int n) throws IOException {
        ByteBuffer buffer;
        byte[] dst = new byte[n];
        int x = 0;
        long p = this.page;
        while (x < n && (buffer = this.getBufferForPage(p)) != null) {
            int r = buffer.remaining();
            for (int i = this.index; i < r && x < n; ++i, ++x) {
                byte b;
                dst[x] = b = buffer.get(i);
            }
            this.index = 0;
            ++p;
        }
        String result = new String(dst);
        return result;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = 0;
        if (this.isPosAfterEnd()) {
            n = -1;
        } else {
            ByteBuffer buffer;
            while (dst.remaining() > 0 && (buffer = this.getBufferForPage(this.page)) != null) {
                ByteBuffer src = buffer.duplicate();
                ((Buffer)src).position(this.displacement + this.index);
                ((Buffer)src).limit(this.displacement + this.relMaxIndexInPage);
                int readContrib = PageNavigator.readRemaining(dst, src);
                n += readContrib;
                if (!this.nextPos(readContrib)) {
                    this.posToEnd();
                    break;
                }
                if (readContrib != 0) continue;
                break;
            }
        }
        return n;
    }

    public static int readRemaining(ByteBuffer dst, ByteBuffer src) {
        int n = Math.min(src.remaining(), dst.remaining());
        ((Buffer)src).limit(src.position() + n);
        dst.put(src);
        return n;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    public void closeActual() throws Exception {
        if (this.pageObj != null) {
            try {
                if (!this.pageObj.isClosed()) {
                    this.pageObj.close();
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.pageObj = null;
        }
    }
}

