/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.slice;

import com.esotericsoftware.kryo.pool.KryoPool;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.LongFunction;
import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.cache.async.AsyncClaimingCacheImpl;
import org.aksw.commons.collection.rangeset.RangeSetDelegate;
import org.aksw.commons.collection.rangeset.RangeSetDelegateMutable;
import org.aksw.commons.collection.rangeset.RangeSetDelegateMutableImpl;
import org.aksw.commons.collection.rangeset.RangeSetOps;
import org.aksw.commons.collection.rangeset.RangeSetUnion;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.array.BufferLike;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.buffer.plain.BufferDelegate;
import org.aksw.commons.io.buffer.plain.BufferOverArray;
import org.aksw.commons.io.buffer.plain.BufferWithPages;
import org.aksw.commons.io.buffer.range.RangeBuffer;
import org.aksw.commons.io.buffer.range.RangeBufferDelegateMutable;
import org.aksw.commons.io.buffer.range.RangeBufferDelegateMutableImpl;
import org.aksw.commons.io.buffer.range.RangeBufferImpl;
import org.aksw.commons.io.buffer.range.RangeBufferUnion;
import org.aksw.commons.io.slice.BufferView;
import org.aksw.commons.io.slice.SliceBase;
import org.aksw.commons.io.slice.SliceMetaDataBasic;
import org.aksw.commons.io.slice.SliceMetaDataWithPages;
import org.aksw.commons.io.slice.SliceMetaDataWithPagesImpl;
import org.aksw.commons.io.slice.SliceWithPages;
import org.aksw.commons.store.object.key.api.ObjectResource;
import org.aksw.commons.store.object.key.api.ObjectStore;
import org.aksw.commons.store.object.key.api.ObjectStoreConnection;
import org.aksw.commons.store.object.key.impl.KryoUtils;
import org.aksw.commons.store.object.key.impl.ObjectStoreImpl;
import org.aksw.commons.store.object.path.api.ObjectSerializer;
import org.aksw.commons.store.object.path.impl.ObjectSerializerKryo;
import org.aksw.commons.txn.api.TxnApi;
import org.aksw.commons.txn.impl.PathDiffState;
import org.aksw.commons.txn.impl.PathState;
import org.aksw.commons.txn.impl.TxnHandler;
import org.aksw.commons.util.closeable.Disposable;
import org.aksw.commons.util.concurrent.ScheduleOnce;
import org.aksw.commons.util.lock.LockUtils;
import org.aksw.commons.util.page.PageUtils;
import org.aksw.commons.util.ref.RefFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceWithPagesSyncToDisk<A>
extends SliceBase<A>
implements SliceWithPages<A> {
    protected Logger logger = LoggerFactory.getLogger(SliceWithPagesSyncToDisk.class);
    protected ObjectStore objectStore;
    protected org.aksw.commons.path.core.Path<String> objectStoreBasePath;
    protected AsyncClaimingCache<Long, BufferView<A>> pageCache;
    protected int pageSize;
    protected RangeSetDelegateMutable<Long> baseRanges;
    protected SliceMetaDataWithPages baseMetaData;
    protected PathDiffState baseMetaDataStatus;
    protected SliceMetaDataWithPages liveMetaData;
    protected RangeSet<Long> liveMetaDataLoadedRangesView = new RangeSetDelegate<Long>(){

        public RangeSet<Long> getDelegate() {
            return SliceWithPagesSyncToDisk.this.liveMetaData.getLoadedRanges();
        }

        public String toString() {
            return Objects.toString(this.getDelegate());
        }
    };
    protected SliceMetaDataWithPages syncMetaData;
    protected PathState metaDataIdentity;
    protected ScheduleOnce syncScheduler;
    protected int liveGeneration = 0;
    protected RangeBufferDelegateMutable<A> liveChanges = new RangeBufferDelegateMutableImpl();
    protected RangeBufferDelegateMutable<A> syncChanges = new RangeBufferDelegateMutableImpl();
    protected LongFunction<String> pageIdToFileName;

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    @Override
    public void setMinimumKnownSize(long minimumKnownSize) {
        this.liveMetaData.setMinimumKnownSize(minimumKnownSize);
        this.syncScheduler.scheduleTask();
    }

    @Override
    public void setMaximumKnownSize(long maximumKnownSize) {
        this.liveMetaData.setMaximumKnownSize(maximumKnownSize);
        this.syncScheduler.scheduleTask();
    }

    public SliceWithPagesSyncToDisk(ArrayOps<A> arrayOps, ObjectStore objectStore, org.aksw.commons.path.core.Path<String> objectStoreBasePath, int pageSize, Duration syncDelay) {
        super(arrayOps);
        this.objectStore = objectStore;
        this.objectStoreBasePath = objectStoreBasePath;
        this.syncScheduler = ScheduleOnce.scheduleOneTaskAtATime((Duration)syncDelay, () -> {
            this.sync();
            return null;
        });
        this.loadMetaData(pageSize);
        this.syncChanges.setDelegate(this.newChangeBuffer());
    }

    @Override
    protected SliceMetaDataBasic getMetaData() {
        return this.liveMetaData;
    }

    public void loadMetaData(int pageSize) {
        this.baseRanges = new RangeSetDelegateMutableImpl();
        try (ObjectStoreConnection conn = this.objectStore.getConnection();){
            TxnApi.execRead((TxnApi)conn, () -> this.lockAndSyncMetaData(conn, pageSize));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.pageSize = this.baseMetaData.getPageSize();
        this.liveChanges.setDelegate(this.newChangeBuffer());
        this.liveMetaData = SliceWithPagesSyncToDisk.copyWithNewRanges(this.baseMetaData, (RangeSet<Long>)RangeSetOps.union(this.liveChanges.getRanges(), this.baseRanges));
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(8);
        df.setGroupingUsed(false);
        this.pageIdToFileName = pageId -> "segment-" + df.format(pageId) + ".ser";
        this.pageCache = AsyncClaimingCacheImpl.newBuilder((Caffeine)Caffeine.newBuilder().maximumSize(100L)).setCacheLoader(this::loadPage).build();
    }

    public static <A> SliceWithPagesSyncToDisk<A> create(ArrayOps<A> arrayOps, ObjectStore objectStore, org.aksw.commons.path.core.Path<String> objectStoreBasePath, int pageSize, Duration syncDelay) {
        return new SliceWithPagesSyncToDisk<A>(arrayOps, objectStore, objectStoreBasePath, pageSize, syncDelay);
    }

    public static <A> SliceWithPagesSyncToDisk<A> create(ArrayOps<A> arrayOps, Path repoPath, org.aksw.commons.path.core.Path<String> objectStoreBasePath, int pageSize, Duration syncDelay) {
        KryoPool kryoPool = KryoUtils.createKryoPool(null);
        ObjectSerializerKryo objectSerializer = ObjectSerializerKryo.create((KryoPool)kryoPool);
        ObjectStore objectStore = ObjectStoreImpl.create((Path)repoPath, (ObjectSerializer)objectSerializer);
        return new SliceWithPagesSyncToDisk<A>(arrayOps, objectStore, objectStoreBasePath, pageSize, syncDelay);
    }

    protected RangeBuffer<A> newChangeBuffer() {
        BufferWithPages actualBuffer = BufferWithPages.create(this.arrayOps, this.pageSize);
        return RangeBufferImpl.create(actualBuffer);
    }

    @Override
    public RefFuture<BufferView<A>> getPageForPageId(long pageId) {
        return this.pageCache.claim((Object)pageId).acquireTransformedAndCloseThis(buf -> {
            InternalBufferView bufferView = (InternalBufferView)buf;
            bufferView.getBaseBuffer().reloadIfNeeded().whenComplete((b, t) -> {
                if (t != null && this.logger.isErrorEnabled()) {
                    this.logger.error("Reloading buffer failed", t);
                }
            });
            return buf;
        });
    }

    @Override
    public RangeSet<Long> getGaps(Range<Long> requestRange) {
        return this.liveMetaData.getGaps(requestRange);
    }

    public boolean hasMetaDataChanged() {
        boolean result;
        String resourceName = "metadata.ser";
        PathDiffState recencyStatus = this.objectStore.fetchRecencyStatus(this.objectStoreBasePath.resolve((Object)resourceName));
        boolean bl = result = !recencyStatus.equals((Object)this.baseMetaDataStatus);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Metadata changed: " + result + "; status now: " + String.valueOf(recencyStatus) + " - before: " + String.valueOf(this.baseMetaDataStatus));
        }
        return result;
    }

    public int lockAndSyncMetaData(ObjectStoreConnection conn, int fallbackPageSize) {
        int result;
        String resourceName = "metadata.ser";
        ObjectResource res = conn.access(this.objectStoreBasePath.resolve((Object)resourceName));
        boolean hasMetaDataChanged = this.hasMetaDataChanged();
        if (hasMetaDataChanged) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Metadata was externally modified on disk... attempting to acquire lock for reload...");
            }
            result = (Integer)LockUtils.runWithLock((Lock)this.readWriteLock.writeLock(), () -> {
                PathDiffState status = res.fetchRecencyStatus();
                SliceMetaDataWithPages newMetaData = (SliceMetaDataWithPages)res.loadNewInstance();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Lock for reload acquired");
                }
                if (newMetaData != null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Loaded metadata: " + String.valueOf(newMetaData));
                    }
                    this.baseMetaData = newMetaData;
                } else {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Created fresh slice metadata");
                    }
                    this.baseMetaData = new SliceMetaDataWithPagesImpl(fallbackPageSize);
                }
                this.baseMetaDataStatus = status;
                this.baseRanges.setDelegate(this.baseMetaData.getLoadedRanges());
                ++this.liveGeneration;
                return this.liveGeneration;
            });
        } else {
            result = (Integer)LockUtils.runWithLock((Lock)this.readWriteLock.readLock(), () -> this.liveGeneration);
        }
        return result;
    }

    public BufferView<A> loadPage(long pageId) {
        String fileName = this.pageIdToFileName.apply(pageId);
        BufferWithAutoReloadOnAccess baseBuffer = new BufferWithAutoReloadOnAccess(fileName);
        long pageOffset = PageUtils.getPageOffsetForId((long)pageId, (long)this.pageSize);
        RangeBufferImpl baseRangeBuffer = RangeBufferImpl.create(this.baseRanges, pageOffset, baseBuffer);
        BufferLike deltaRangeBuffer1 = this.syncChanges.slice(pageOffset, this.pageSize);
        BufferLike deltaRangeBuffer2 = this.liveChanges.slice(pageOffset, this.pageSize);
        RangeBufferUnion unionBuffer = RangeBufferUnion.create(baseRangeBuffer, deltaRangeBuffer1);
        RangeBufferUnion finalUnionBuffer = RangeBufferUnion.create(deltaRangeBuffer2, unionBuffer);
        return new InternalBufferView(baseBuffer, finalUnionBuffer);
    }

    public BufferView<A> loadPages(boolean isEager, Set<Long> pageIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    public static SliceMetaDataWithPages copyWithNewRanges(SliceMetaDataWithPages base, RangeSet<Long> rangeSet) {
        return new SliceMetaDataWithPagesImpl(base.getPageSize(), rangeSet, base.getFailedRanges(), base.getMinimumKnownSize(), base.getMaximumKnownSize());
    }

    public synchronized void sync() throws IOException {
        NavigableSet idsOfDirtyPages = Collections.emptySet();
        Stopwatch stopwatch = Stopwatch.createStarted();
        LockUtils.runWithLock((Lock)this.readWriteLock.writeLock(), () -> {
            this.syncChanges.setDelegate((RangeBuffer)this.liveChanges.getDelegate());
            this.liveChanges.setDelegate(this.newChangeBuffer());
            RangeSetUnion newLiveRanges = RangeSetOps.union(this.liveChanges.getRanges(), (RangeSet)RangeSetOps.union(this.syncChanges.getRanges(), this.baseRanges));
            this.syncMetaData = this.liveMetaData;
            this.liveMetaData = new SliceMetaDataWithPagesImpl(this.syncMetaData.getPageSize(), (RangeSet<Long>)newLiveRanges, (RangeMap<Long, List<Throwable>>)TreeRangeMap.create(), this.syncMetaData.getMinimumKnownSize(), this.syncMetaData.getMaximumKnownSize());
        });
        final String metadataFileName = "metadata.ser";
        try (ObjectStoreConnection conn = this.objectStore.getConnection();){
            conn.begin(true);
            final ObjectResource res = conn.access(this.objectStoreBasePath.resolve((Object)metadataFileName));
            int generationNow = this.lockAndSyncMetaData(conn, this.pageSize);
            TreeRangeSet materializedRanges = TreeRangeSet.create();
            materializedRanges.addAll(this.baseRanges);
            materializedRanges.addAll(this.syncChanges.getRanges());
            SliceMetaDataWithPages newBaseMetadata = SliceWithPagesSyncToDisk.copyWithNewRanges(this.syncMetaData, (RangeSet<Long>)materializedRanges);
            if (!newBaseMetadata.equals(this.baseMetaData)) {
                res.save((Object)newBaseMetadata);
            }
            idsOfDirtyPages = PageUtils.touchedPageIndices((Collection)this.syncChanges.getRanges().asRanges(), (long)this.pageSize);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Synchronizing " + idsOfDirtyPages.size() + " dirty pages");
            }
            Iterator iterator = idsOfDirtyPages.iterator();
            while (iterator.hasNext()) {
                long pageId = (Long)iterator.next();
                String pageFileName = this.pageIdToFileName.apply(pageId);
                RefFuture pageBuffer = this.pageCache.claim((Object)pageId);
                try {
                    long offset = PageUtils.getPageOffsetForId((long)pageId, (long)this.pageSize);
                    InternalBufferView bufferView = (InternalBufferView)pageBuffer.await();
                    BufferWithAutoReloadOnAccess baseBuffer = bufferView.getBaseBuffer();
                    LockUtils.runWithLock((Lock)this.getReadWriteLock().writeLock(), () -> baseBuffer.updateIfNeeded(generationNow, conn));
                    RangeBufferImpl baseRangeBuffer = RangeBufferImpl.create(this.baseRanges, offset, baseBuffer);
                    BufferLike subRangeBuffer = this.syncChanges.slice(offset, this.pageSize);
                    RangeBufferUnion unionRangeBuffer = RangeBufferUnion.create(subRangeBuffer, baseRangeBuffer);
                    Object array = this.arrayOps.create(this.pageSize);
                    BufferOverArray newBaseBuffer = BufferOverArray.create(this.arrayOps, array);
                    RangeBufferImpl arrayWrapper = RangeBufferImpl.create(newBaseBuffer);
                    LockUtils.runWithLock((Lock)this.getReadWriteLock().readLock(), () -> unionRangeBuffer.transferTo(0L, arrayWrapper, 0L, this.pageSize));
                    ObjectResource pageRes = conn.access(this.objectStoreBasePath.resolve((Object)pageFileName));
                    pageRes.save(array);
                    LockUtils.runWithLock((Lock)this.getReadWriteLock().writeLock(), () -> baseBuffer.setFuture(CompletableFuture.completedFuture(newBaseBuffer)));
                }
                finally {
                    if (pageBuffer == null) continue;
                    pageBuffer.close();
                }
            }
            conn.commit(new TxnHandler(){
                final /* synthetic */ SliceWithPagesSyncToDisk this$0;
                {
                    this.this$0 = this$0;
                }

                public void beforeUnlock(org.aksw.commons.path.core.Path<String> resKey, boolean isCommit) throws Exception {
                    String fn = resKey.getFileName().toString();
                    if (metadataFileName.equals(fn)) {
                        this.this$0.baseMetaDataStatus = res.fetchRecencyStatus();
                    }
                }
            });
            LockUtils.runWithLock((Lock)this.readWriteLock.writeLock(), () -> {
                this.baseRanges.setDelegate((RangeSet)materializedRanges);
                this.syncChanges.setDelegate(this.newChangeBuffer());
                this.baseMetaData = newBaseMetadata;
                this.liveMetaData = SliceWithPagesSyncToDisk.copyWithNewRanges(this.liveMetaData, (RangeSet<Long>)RangeSetOps.union(this.liveChanges.getRanges(), this.baseRanges));
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Synchronization of " + idsOfDirtyPages.size() + " dirty pages completed in " + (float)stopwatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0f + " seconds");
        }
    }

    @Override
    public RangeSet<Long> getLoadedRanges() {
        return this.liveMetaDataLoadedRangesView;
    }

    @Override
    public long getMinimumKnownSize() {
        return this.liveMetaData.getMinimumKnownSize();
    }

    @Override
    public long getMaximumKnownSize() {
        return this.liveMetaData.getMaximumKnownSize();
    }

    @Override
    public Condition getHasDataCondition() {
        return this.hasDataCondition;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public RangeMap<Long, List<Throwable>> getFailedRanges() {
        return this.liveMetaData.getFailedRanges();
    }

    @Override
    public Disposable addEvictionGuard(RangeSet<Long> range) {
        return null;
    }

    class BufferWithAutoReloadOnAccess
    implements BufferDelegate<A> {
        protected String fileName;
        protected int generationHere;
        protected CompletableFuture<Buffer<A>> future;

        public void setFuture(CompletableFuture<Buffer<A>> future) {
            this.future = future;
        }

        public BufferWithAutoReloadOnAccess(String fileName) {
            this.fileName = fileName;
            this.generationHere = -1;
        }

        public int getGenerationHere() {
            return this.generationHere;
        }

        public CompletableFuture<Buffer<A>> reloadIfNeeded() {
            int generationNow = SliceWithPagesSyncToDisk.this.liveGeneration;
            if (this.generationHere != generationNow || this.future == null) {
                ObjectStoreConnection conn = SliceWithPagesSyncToDisk.this.objectStore.getConnection();
                conn.begin(false);
                this.generationHere = SliceWithPagesSyncToDisk.this.lockAndSyncMetaData(conn, SliceWithPagesSyncToDisk.this.pageSize);
                return this.forceLoadPage(conn);
            }
            return this.future;
        }

        public CompletableFuture<Buffer<A>> forceLoadPage(ObjectStoreConnection conn) {
            ObjectResource pageRes = conn.access(SliceWithPagesSyncToDisk.this.objectStoreBasePath.resolve((Object)this.fileName));
            this.future = CompletableFuture.supplyAsync(() -> {
                Object array = pageRes.loadNewInstance();
                if (array == null) {
                    array = SliceWithPagesSyncToDisk.this.arrayOps.create(SliceWithPagesSyncToDisk.this.pageSize);
                }
                BufferOverArray<Object> arrayBuffer = BufferOverArray.create(SliceWithPagesSyncToDisk.this.arrayOps, array);
                return arrayBuffer;
            }).whenComplete((v, t) -> {
                try {
                    conn.commit();
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            });
            return this.future;
        }

        void updateIfNeeded(int generationNow, ObjectStoreConnection conn) {
            if (this.generationHere != generationNow || this.future == null) {
                ObjectResource pageRes = conn.access(SliceWithPagesSyncToDisk.this.objectStoreBasePath.resolve((Object)this.fileName));
                Object array = pageRes.loadNewInstance();
                if (array == null) {
                    array = SliceWithPagesSyncToDisk.this.arrayOps.create(SliceWithPagesSyncToDisk.this.pageSize);
                }
                BufferOverArray<Object> arrayBuffer = BufferOverArray.create(SliceWithPagesSyncToDisk.this.arrayOps, array);
                this.future = CompletableFuture.completedFuture(arrayBuffer);
                this.generationHere = generationNow;
            }
        }

        @Override
        public Buffer<A> getDelegate() {
            try {
                return this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class InternalBufferView
    implements BufferView<A> {
        protected BufferWithAutoReloadOnAccess baseBuffer;
        protected RangeBuffer<A> rangeBufferView;

        public InternalBufferView(BufferWithAutoReloadOnAccess baseBuffer, RangeBuffer<A> rangeBufferView) {
            this.baseBuffer = baseBuffer;
            this.rangeBufferView = rangeBufferView;
        }

        public BufferWithAutoReloadOnAccess getBaseBuffer() {
            return this.baseBuffer;
        }

        @Override
        public RangeBuffer<A> getRangeBuffer() {
            return this.rangeBufferView;
        }

        @Override
        public long getGeneration() {
            return this.baseBuffer.getGenerationHere();
        }

        public String toString() {
            return this.rangeBufferView.toString();
        }

        @Override
        public ReadWriteLock getReadWriteLock() {
            return SliceWithPagesSyncToDisk.this.readWriteLock;
        }
    }
}

