/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.slice;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.cache.async.AsyncClaimingCacheImpl;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.buffer.plain.BufferOverArray;
import org.aksw.commons.io.buffer.range.RangeBuffer;
import org.aksw.commons.io.buffer.range.RangeBufferImpl;
import org.aksw.commons.io.slice.BufferView;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.io.slice.SliceBase;
import org.aksw.commons.io.slice.SliceInMemory;
import org.aksw.commons.io.slice.SliceMetaDataBasic;
import org.aksw.commons.io.slice.SliceMetaDataWithPages;
import org.aksw.commons.io.slice.SliceMetaDataWithPagesImpl;
import org.aksw.commons.io.slice.SliceWithPages;
import org.aksw.commons.util.closeable.Disposable;
import org.aksw.commons.util.lock.LockUtils;
import org.aksw.commons.util.ref.RefFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceInMemoryCache<A>
extends SliceBase<A>
implements SliceWithPages<A> {
    private static final Logger logger = LoggerFactory.getLogger(SliceInMemoryCache.class);
    protected SliceMetaDataWithPages metaData;
    protected AsyncClaimingCache<Long, BufferView<A>> pageCache;

    protected SliceInMemoryCache(ArrayOps<A> arrayOps, int pageSize, AsyncClaimingCacheImpl.Builder<Long, BufferView<A>> cacheBuilder) {
        super(arrayOps);
        this.metaData = new SliceMetaDataWithPagesImpl(pageSize);
        this.pageCache = cacheBuilder.setCacheLoader(this::loadPage).setEvictionListener((k, v, c) -> this.evictPage((long)k)).build();
    }

    public static <A> Slice<A> create(ArrayOps<A> arrayOps, int pageSize, int maxCachedPages) {
        AsyncClaimingCacheImpl.Builder cacheBuilder = AsyncClaimingCacheImpl.newBuilder((Caffeine)Caffeine.newBuilder().maximumSize((long)maxCachedPages));
        return new SliceInMemoryCache<A>(arrayOps, pageSize, cacheBuilder);
    }

    protected void evictPage(long pageId) {
        long pageOffset = this.getPageOffsetForPageId(pageId);
        int pageSize = this.metaData.getPageSize();
        Range pageRange = Range.closedOpen((Comparable)Long.valueOf(pageOffset), (Comparable)Long.valueOf(pageOffset + (long)pageSize));
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to evice page " + pageId + " with range " + String.valueOf(pageRange));
        }
        LockUtils.runWithLock((Lock)this.readWriteLock.writeLock(), () -> this.metaData.getLoadedRanges().remove(pageRange));
        if (logger.isDebugEnabled()) {
            logger.debug("Eviced page " + pageId + " with range " + String.valueOf(pageRange));
        }
    }

    protected BufferView<A> loadPage(long pageId) {
        long pageOffset = this.getPageOffsetForPageId(pageId);
        BufferOverArray<int> buffer = BufferOverArray.create(this.arrayOps, this.metaData.getPageSize());
        final RangeBufferImpl<int> rangeBuffer = RangeBufferImpl.create(this.metaData.getLoadedRanges(), pageOffset, buffer);
        return new BufferView<A>(){
            final /* synthetic */ SliceInMemoryCache this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RangeBuffer<A> getRangeBuffer() {
                return rangeBuffer;
            }

            @Override
            public long getGeneration() {
                return 0L;
            }

            @Override
            public ReadWriteLock getReadWriteLock() {
                return this.this$0.readWriteLock;
            }
        };
    }

    public static <A> SliceInMemory<A> create(ArrayOps<A> arrayOps, Buffer<A> buffer) {
        return new SliceInMemory<A>(arrayOps, buffer);
    }

    @Override
    protected SliceMetaDataBasic getMetaData() {
        return this.metaData;
    }

    public void sync() throws IOException {
    }

    @Override
    public long getPageSize() {
        return this.metaData.getPageSize();
    }

    @Override
    public RefFuture<BufferView<A>> getPageForPageId(long pageId) {
        return this.pageCache.claim((Object)pageId);
    }

    @Override
    public Disposable addEvictionGuard(RangeSet<Long> ranges) {
        return this.pageCache.addEvictionGuard(key -> ranges.contains((Comparable)key));
    }
}

