/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.slice;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.slice.SliceAccessor;
import org.aksw.commons.io.slice.SliceMetaDataBasic;
import org.aksw.commons.io.util.Sync;
import org.aksw.commons.util.closeable.Disposable;

public interface Slice<T>
extends SliceMetaDataBasic,
Sync {
    public ReadWriteLock getReadWriteLock();

    public Condition getHasDataCondition();

    public ArrayOps<T> getArrayOps();

    public Disposable addEvictionGuard(RangeSet<Long> var1);

    default public boolean isComplete() {
        boolean result = this.computeFromMetaData(false, metaData -> {
            long knownSize = metaData.getKnownSize();
            Set ranges = metaData.getLoadedRanges().asRanges();
            Range range = ranges.size() == 1 ? (Range)ranges.iterator().next() : null;
            long endpoint = range != null ? (Long)range.upperEndpoint() : -1L;
            boolean r = knownSize >= 0L && endpoint >= 0L && knownSize == endpoint;
            return r;
        });
        return result;
    }

    default public void mutateMetaData(Consumer<? super SliceMetaDataBasic> fn) {
        this.computeFromMetaData(true, metaData -> {
            fn.accept((SliceMetaDataBasic)metaData);
            return null;
        });
    }

    default public void readMetaData(Consumer<? super SliceMetaDataBasic> fn) {
        this.computeFromMetaData(false, metaData -> {
            fn.accept((SliceMetaDataBasic)metaData);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <X> X computeFromMetaData(boolean isWrite, Function<? super SliceMetaDataBasic, X> fn) {
        X result;
        ReadWriteLock rwl = this.getReadWriteLock();
        Lock lock = isWrite ? rwl.writeLock() : rwl.readLock();
        lock.lock();
        try {
            result = fn.apply(this);
            if (isWrite) {
                this.getHasDataCondition().signalAll();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public SliceAccessor<T> newSliceAccessor();
}

