/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.slice;

import java.io.IOException;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannelBase;
import org.aksw.commons.io.slice.SliceAccessor;

public class ReadableChannelOverSliceAccessor<A>
extends ReadableChannelBase<A> {
    protected SliceAccessor<A> accessor;
    protected long posInSlice;

    public ReadableChannelOverSliceAccessor(SliceAccessor<A> accessor, long posInSlice) {
        this.accessor = accessor;
        this.posInSlice = posInSlice;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.accessor.getSlice().getArrayOps();
    }

    public void closeActual() throws IOException {
        this.accessor.close();
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        this.accessor.claimByOffsetRange(this.posInSlice, this.posInSlice + (long)length);
        int result = this.accessor.unsafeRead(array, position, this.posInSlice, length);
        if (result > 0) {
            this.posInSlice += (long)result;
        }
        return result;
    }
}

