/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.seekable.impl;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.impl.BlockEnumerator;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;
import org.aksw.commons.util.ref.Ref;

public class SeekableFromBlock
extends AutoCloseableWithLeakDetectionBase
implements Seekable {
    protected Ref<? extends Block> startBlockRef;
    protected int startPosInStartSegment;
    protected long exposedStartPos;
    protected long maxPos;
    protected long minPos;
    protected Ref<? extends Block> currentBlockRef;
    protected Block currentBlock;
    protected Seekable currentSeekable;
    protected long actualPos;

    public SeekableFromBlock(Ref<? extends Block> startBlockRef, int posInStartSegment, long exposedStartPos) {
        this(startBlockRef, posInStartSegment, exposedStartPos, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public SeekableFromBlock(Ref<? extends Block> startBlockRef, int posInStartSegment, long exposedStartPos, long minPos, long maxPos) {
        this.startBlockRef = startBlockRef;
        this.startPosInStartSegment = posInStartSegment;
        this.exposedStartPos = exposedStartPos;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.actualPos = 0L;
        this.init();
    }

    protected void init() {
        this.currentBlockRef = this.startBlockRef.acquire(null);
        this.currentBlock = (Block)this.currentBlockRef.get();
        this.currentSeekable = (Seekable)this.currentBlock.newChannel();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    public void closeActual() throws Exception {
        this.currentSeekable.close();
        this.currentBlockRef.close();
        this.startBlockRef.close();
    }

    @Override
    public Seekable clone() {
        SeekableFromBlock result = new SeekableFromBlock((Ref<? extends Block>)this.startBlockRef.acquire(null), this.startPosInStartSegment, this.exposedStartPos, this.minPos, this.maxPos);
        result.actualPos = this.actualPos;
        try {
            long posInSeekable = this.currentSeekable.getPos();
            result.currentSeekable.setPos(posInSeekable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public long getPos() throws IOException {
        return this.actualPos;
    }

    @Override
    public void setPos(long pos) throws IOException {
        int delta = Ints.checkedCast((long)(pos - this.actualPos));
        if (delta > 0) {
            this.checkNext(delta, true);
        } else if (delta < 0) {
            this.checkPrev(-delta, true);
        }
    }

    @Override
    public void posToStart() throws IOException {
        try {
            this.currentBlockRef.close();
            this.currentBlockRef = this.startBlockRef.acquire(null);
            this.currentBlock = (Block)this.currentBlockRef.get();
            this.currentSeekable = (Seekable)this.currentBlock.newChannel();
            this.currentSeekable.posToStart();
            this.actualPos = this.exposedStartPos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.actualPos = -1L;
    }

    @Override
    public void posToEnd() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPosBeforeStart() throws IOException {
        boolean result = this.actualPos < this.minPos;
        return result;
    }

    Ref<? extends Block> openNextCloseCurrent(Ref<? extends Block> current, Ref<? extends Block> exclude) throws IOException {
        Ref<? extends Block> result = ((Block)current.get()).nextBlock();
        try {
            if (current != exclude) {
                current.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return result;
    }

    @Override
    public boolean isPosAfterEnd() throws IOException {
        boolean result = this.currentSeekable.isPosAfterEnd();
        if (result) {
            BlockEnumerator it = BlockEnumerator.fwd(false, this.currentBlockRef, this.currentSeekable);
            while (it.hasNext()) {
                it.advance();
                if (it.seekable.isPosAfterEnd()) continue;
                result = true;
                break;
            }
            it.closeCurrent();
        }
        return result;
    }

    protected boolean loadNextBlock() throws IOException {
        boolean result;
        Ref<? extends Block> nextBlockRef = ((Block)this.currentBlockRef.get()).nextBlock();
        boolean bl = result = nextBlockRef != null;
        if (result) {
            try {
                this.currentBlockRef.close();
                this.currentSeekable.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.currentBlockRef = nextBlockRef;
            this.currentBlock = (Block)this.currentBlockRef.get();
            this.currentSeekable = (Seekable)this.currentBlock.newChannel();
        }
        return result;
    }

    Supplier<State> nexts() {
        State[] current = new State[]{new State(this.currentBlockRef, this.currentSeekable)};
        return () -> current[0];
    }

    @Override
    public int posToNext(byte delimiter, boolean changePos) throws IOException {
        int result;
        int contrib = this.currentSeekable.posToNext(delimiter, changePos);
        int posDelta = 0;
        if (contrib >= 0) {
            result = contrib;
        } else {
            Ref<? extends Block> tmpBlockRef = this.currentBlockRef;
            Block tmpBlock = this.currentBlock;
            Seekable tmpSeekable = this.currentSeekable;
            while (contrib < 0) {
                Ref<? extends Block> nextBlockRef;
                posDelta += -contrib + 1;
                Ref<? extends Block> ref = nextBlockRef = contrib > 0 ? null : ((Block)tmpBlockRef.get()).nextBlock();
                if (nextBlockRef == null) {
                    this.currentBlockRef = tmpBlockRef;
                    this.currentBlock = tmpBlock;
                    this.currentSeekable = tmpSeekable;
                    tmpSeekable.posToEnd();
                } else {
                    if (tmpBlockRef != null && tmpBlockRef != this.currentBlockRef) {
                        tmpSeekable.close();
                        try {
                            tmpBlockRef.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((contrib = (tmpSeekable = (Seekable)(tmpBlock = (Block)nextBlockRef.get()).newChannel()).posToNext(delimiter, false)) > 0) {
                        this.currentSeekable.close();
                        try {
                            this.currentBlockRef.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        this.currentBlockRef = nextBlockRef;
                        this.currentBlock = (Block)this.currentBlockRef.get();
                        this.currentSeekable = tmpSeekable;
                        break;
                    }
                }
                try {
                    tmpBlockRef.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                tmpSeekable.close();
            }
            result = -1;
        }
        return result;
    }

    @Override
    public int compareToPrefix(byte[] prefix) throws IOException {
        int result;
        int l = prefix.length;
        if (l == this.currentSeekable.checkNext(l, false)) {
            result = this.currentSeekable.compareToPrefix(prefix);
        } else {
            byte[] tmp = new byte[l];
            int available = this.peekNextBytes(tmp, 0, l);
            result = Seekable.compareArrays(tmp, prefix);
        }
        return result;
    }

    void setCurrent(BlockEnumerator state) {
        if (this.currentBlockRef != state.getCurrentBlockRef()) {
            this.currentBlockRef.close();
            try {
                this.currentBlock.close();
                this.currentSeekable.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.currentBlockRef = state.getCurrentBlockRef();
        this.currentBlock = state.getCurrentBlock();
        this.currentSeekable = state.getCurrentSeekable();
    }

    @Override
    public int checkNext(int len, boolean changePos) throws IOException {
        int contrib;
        int result = contrib = this.currentSeekable.checkNext(len, changePos);
        if (contrib < len) {
            BlockEnumerator it = BlockEnumerator.fwd(false, this.currentBlockRef, this.currentSeekable);
            while (it.hasNext()) {
                int remaining = len - result;
                it.advance();
                it.seekable.posToStart();
                contrib = it.seekable.checkNext(remaining, changePos);
                if ((result += contrib) < len) continue;
                break;
            }
            if (changePos) {
                this.setCurrent(it);
            } else {
                it.closeCurrent();
            }
        }
        if (changePos) {
            this.actualPos += (long)result;
        }
        return result;
    }

    @Override
    public int checkPrev(int len, boolean changePos) throws IOException {
        int contrib;
        int result = contrib = this.currentSeekable.checkPrev(len, changePos);
        if (contrib < len) {
            BlockEnumerator it = BlockEnumerator.bwd(false, this.currentBlockRef, this.currentSeekable);
            while (it.hasNext()) {
                int remaining = len - result;
                it.advance();
                it.seekable.posToEnd();
                contrib = it.seekable.checkPrev(remaining, changePos);
                if ((result += contrib) < len) continue;
                break;
            }
            if (changePos) {
                this.setCurrent(it);
            } else {
                it.closeCurrent();
            }
        }
        if (changePos) {
            this.actualPos -= (long)result;
        }
        return result;
    }

    @Override
    public byte get() throws IOException {
        byte r = this.currentSeekable.get();
        return r;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int contrib = 0;
        BlockEnumerator it = BlockEnumerator.fwd(true, this.currentBlockRef, this.currentSeekable);
        while (it.hasNext() && dst.remaining() > 0) {
            it.advance();
            while (dst.remaining() > 0) {
                int n = it.seekable.read(dst);
                if (n == 0) {
                    throw new RuntimeException("Read returned 0 bytes - this should never be the case");
                }
                if (n == -1) break;
                contrib += n;
                this.actualPos += (long)n;
            }
            if (dst.remaining() != 0) continue;
        }
        this.setCurrent(it);
        int result = contrib == 0 ? -1 : contrib;
        return result;
    }

    public int readBroken(ByteBuffer dst) throws IOException {
        int n = -1;
        int contrib = 0;
        while (this.currentSeekable != null && dst.remaining() > 0) {
            n = this.currentSeekable.read(dst);
            if (n == 0) {
                throw new RuntimeException("Read returned 0 bytes - this should never be the case");
            }
            if (n == -1) {
                this.loadNextBlock();
                continue;
            }
            contrib += n;
            this.actualPos += (long)n;
        }
        return contrib;
    }

    @Override
    public String readString(int len) throws IOException {
        throw new RuntimeException("not implemented");
    }

    class State {
        Ref<? extends Block> blockRef;
        Seekable channel;

        public State(Ref<? extends Block> blockRef, Seekable channel) {
            this.blockRef = blockRef;
            this.channel = channel;
        }
    }
}

