/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.primitives.Ints;
import java.io.IOException;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.GetPosition;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelDecoratorBase;

public class ReadableChannelWithLimitByDelimiter<A, X extends ReadableChannel<A>>
extends ReadableChannelDecoratorBase<A, X> {
    protected long nextSplitOffset;
    protected byte delimiter;
    protected boolean isInEofState = false;
    protected long bytesRead = 0L;
    protected A excessBuffer;
    protected GetPosition getPosition;
    protected boolean isBlockMode;

    public ReadableChannelWithLimitByDelimiter(X delegate, GetPosition getPosition, boolean isBlockMode, byte delimiter, long nextSplitOffset) {
        super(delegate);
        this.getPosition = getPosition;
        this.isBlockMode = isBlockMode;
        this.delimiter = delimiter;
        this.nextSplitOffset = nextSplitOffset;
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        int result = 0;
        while (result == 0) {
            if (this.isInEofState) {
                result = -1;
            } else {
                boolean isInNextSplit;
                long pos = this.getPosition.call();
                boolean bl = isInNextSplit = pos >= this.nextSplitOffset;
                if (!isInNextSplit) {
                    int allowed = this.isBlockMode ? length : Math.min(length, Ints.saturatedCast((long)(this.nextSplitOffset - pos)));
                    result = ((ReadableChannel)this.getDelegate()).read(array, position, allowed);
                } else {
                    int excessBufferSize = 1024;
                    ArrayOps<A> arrayOps = this.getArrayOps();
                    if (this.excessBuffer == null) {
                        this.excessBuffer = this.getArrayOps().create(excessBufferSize);
                    }
                    int l = Math.min(length, excessBufferSize);
                    int n = ((ReadableChannel)this.getDelegate()).read(this.excessBuffer, 0, l);
                    if (n >= 0) {
                        int i;
                        for (i = 0; i < n; ++i) {
                            byte b = arrayOps.getByte(this.excessBuffer, i);
                            if (b != this.delimiter) continue;
                            ++i;
                            this.isInEofState = true;
                            break;
                        }
                        arrayOps.copy(this.excessBuffer, 0, array, position, i);
                        result = i;
                    } else {
                        result = n;
                    }
                }
            }
            if (result > 0) {
                this.bytesRead += (long)result;
                break;
            }
            if (result == -1) {
                this.isInEofState = true;
                break;
            }
            if (result == -2) {
                if (!this.isBlockMode) {
                    throw new IllegalStateException("read return -2 but block mode was not enabled on this channel.");
                }
                result = 0;
                continue;
            }
            if (result == 0) {
                throw new RuntimeException("Zero-byte read.");
            }
            throw new RuntimeException("Unknown negative value: " + result);
        }
        return result;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

