/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.SeekableReadableChannels;

public class ReadableChannelSourceOverPath
implements ReadableChannelSource<byte[]> {
    protected Path path;
    protected long predefinedSize;

    public ReadableChannelSourceOverPath(Path path, long predefinedSize) {
        this.path = path;
        this.predefinedSize = predefinedSize;
    }

    @Override
    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    @Override
    public ReadableChannel<byte[]> newReadableChannel(Range<Long> range) throws IOException {
        ReadableChannel<byte[]> result;
        ContiguousSet set = ContiguousSet.create(range, (DiscreteDomain)DiscreteDomain.longs());
        if (set.isEmpty()) {
            result = SeekableReadableChannels.empty(ArrayOps.BYTE);
        } else {
            long pos = (Long)set.first();
            Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0, (Object)"Ranges must start with 0 or greater");
            FileChannel fc = FileChannel.open(this.path, StandardOpenOption.READ);
            fc.position(pos);
            result = ReadableChannels.wrap(fc);
            if (range.hasUpperBound()) {
                long len = (Long)set.last() + 1L - pos;
                result = ReadableChannels.limit(result, len);
            }
        }
        return result;
    }

    @Override
    public long size() throws IOException {
        long result = this.predefinedSize >= 0L ? this.predefinedSize : Files.size(this.path);
        return result;
    }
}

