/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannel;

public class ReadableChannelOverNio<T extends ReadableByteChannel>
implements ReadableChannel<byte[]> {
    protected T delegate;

    public ReadableChannelOverNio(T channel) {
        this.delegate = channel;
    }

    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }

    @Override
    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    @Override
    public int read(byte[] array, int position, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(array, position, length);
        int result = this.getDelegate().read(buf);
        return result;
    }
}

