/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.aksw.commons.io.input.ReadableChannel;

public class ReadableByteChannelAdapter<T extends ReadableChannel<byte[]>>
implements ReadableByteChannel {
    protected T delegate;
    protected byte[] buf;
    protected final int transferSize = 8192;

    public ReadableByteChannelAdapter(T delegate) {
        this.delegate = (ReadableChannel)Objects.requireNonNull(delegate);
    }

    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }

    @Override
    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int r;
        int n = dst.remaining();
        if (dst.hasArray()) {
            byte[] arr = dst.array();
            int arrPos = dst.arrayOffset() + dst.position();
            r = this.getDelegate().read((byte[])arr, arrPos, n);
            if (r > 0) {
                dst.position(dst.position() + r);
            }
        } else {
            if (this.buf == null) {
                this.buf = new byte[8192];
            }
            int l = Math.min(this.buf.length, n);
            r = this.getDelegate().read((byte[])this.buf, 0, l);
            if (r > 0) {
                dst.put(this.buf, 0, r);
            }
        }
        return r;
    }
}

