/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class ChannelMonitor2 {
    protected volatile NavigableMap<Long, RangeTracker> trackedReads = new TreeMap<Long, RangeTracker>();
    protected AtomicLong readCounter = new AtomicLong();
    protected AtomicLong readAmount = new AtomicLong();

    public void addReadAmount(long readAmount) {
        this.readAmount.addAndGet(readAmount);
    }

    public void incReadCounter() {
        this.readCounter.addAndGet(1L);
    }

    public long getReadCounter() {
        return this.readCounter.get();
    }

    public long getReadAmount() {
        return this.readAmount.get();
    }

    public NavigableMap<Long, RangeTracker> getTrackedReads() {
        return this.trackedReads;
    }

    public synchronized void submitReadStats(long offset, long readStartPos, long readEndPos, int readLength, long durationNanos) {
        if (readLength > 0) {
            RangeTracker tracker = this.trackedReads.computeIfAbsent(offset, o -> new RangeTracker());
            RangeTracker contrib = new RangeTracker(readLength, durationNanos);
            tracker.add(contrib);
        }
    }

    public void dumpJson(OutputStream out) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (JsonWriter w = gson.newJsonWriter((Writer)new OutputStreamWriter(out));){
            w.beginArray();
            for (Map.Entry e : this.getTrackedReads().entrySet()) {
                w.beginObject();
                w.name("offset");
                w.value((Number)e.getKey());
                w.name("length");
                w.value(((RangeTracker)e.getValue()).getTotalReadLength());
                w.endObject();
            }
            w.endArray();
        }
    }

    public class RangeTracker {
        protected long totalDurationNanos;
        protected int minReadLength;
        protected int maxReadLength;
        protected long totalReadLength;
        protected long readCount;

        public RangeTracker() {
            this(Integer.MAX_VALUE, 0, 0L, 0L, 0L);
        }

        public RangeTracker(int readLength, long totalDurationNanos) {
            this(readLength, readLength, readLength, totalDurationNanos, 1L);
        }

        public RangeTracker(int minReadLength, int maxReadLength, long totalReadLength, long totalDurationNanos, long readCount) {
            this.totalDurationNanos = totalDurationNanos;
            this.minReadLength = minReadLength;
            this.maxReadLength = maxReadLength;
            this.totalReadLength = totalReadLength;
            this.readCount = readCount;
        }

        public long getTotalDurationNanos() {
            return this.totalDurationNanos;
        }

        public int getMinReadLength() {
            return this.minReadLength;
        }

        public long getTotalReadLength() {
            return this.totalReadLength;
        }

        public int getMaxReadLength() {
            return this.maxReadLength;
        }

        public long getReadCount() {
            return this.readCount;
        }

        public void add(RangeTracker contrib) {
            this.totalDurationNanos += contrib.totalDurationNanos;
            this.maxReadLength = Math.max(this.maxReadLength, contrib.maxReadLength);
            this.minReadLength = this.minReadLength == -1 ? contrib.minReadLength : Math.min(this.minReadLength, contrib.minReadLength);
            this.totalReadLength += contrib.totalReadLength;
            ++this.readCount;
        }

        protected RangeTracker clone() {
            return new RangeTracker(this.minReadLength, this.maxReadLength, this.totalReadLength, this.totalDurationNanos, this.readCount);
        }
    }
}

