/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.array;

import java.nio.ByteBuffer;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;

public interface ArraySink<A> {
    public void put(A var1, int var2, int var3);

    public int remaining();

    public int limit();

    public static ArraySink<byte[]> forByteBuffer(ByteBuffer byteBuffer) {
        return new ArraySinkByteBuffer(byteBuffer);
    }

    public static class ArraySinkByteBuffer
    implements ArraySink<byte[]> {
        protected ByteBuffer byteBuffer;

        public ArraySinkByteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        @Override
        public void put(byte[] input, int offset, int length) {
            this.byteBuffer.put(input, offset, length);
        }

        @Override
        public int remaining() {
            return this.byteBuffer.remaining();
        }

        @Override
        public int limit() {
            return this.byteBuffer.limit();
        }
    }

    public static class ArraySinkBuffer<A>
    implements ArraySink<A> {
        protected Buffer<A> buffer;
        protected long offsetInBuffer;

        public ArraySinkBuffer(Buffer<A> buffer, int offsetInBuffer) {
            this.buffer = buffer;
            this.offsetInBuffer = offsetInBuffer;
        }

        public Buffer<A> getBuffer() {
            return this.buffer;
        }

        @Override
        public void put(A input, int offset, int length) {
        }

        @Override
        public int remaining() {
            return (int)(this.buffer.getCapacity() - this.offsetInBuffer);
        }

        @Override
        public int limit() {
            return (int)this.buffer.getCapacity();
        }
    }

    public static class ArraySinkArray<A>
    implements ArraySink<A> {
        protected ArrayOps<A> arrayOps;
        protected A array;
        protected int offsetInArray;
        protected int limit;

        public ArraySinkArray(ArrayOps<A> arrayOps, A array, int offsetInArray, int limit) {
            this.arrayOps = arrayOps;
            this.array = array;
            this.offsetInArray = offsetInArray;
            this.limit = limit;
        }

        public A getArray() {
            return this.array;
        }

        @Override
        public void put(A input, int offset, int length) {
            this.arrayOps.copy(input, offset, this.array, this.offsetInArray, length);
            this.offsetInArray += length;
        }

        @Override
        public int remaining() {
            return this.limit() - this.offsetInArray;
        }

        @Override
        public int limit() {
            return this.limit;
        }
    }
}

