/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.array;

import java.lang.reflect.Array;
import java.util.function.IntFunction;
import org.aksw.commons.io.buffer.array.ArrayOpsByte;
import org.aksw.commons.io.buffer.array.ArrayOpsByteBuffer;
import org.aksw.commons.io.buffer.array.ArrayOpsObject;

public interface ArrayOps<A> {
    public static final ArrayOpsByte BYTE = new ArrayOpsByte();
    public static final ArrayOpsByteBuffer BYTE_BUFFER = new ArrayOpsByteBuffer();
    public static final ArrayOpsObject<Object> OBJECT = ArrayOps.createFor(Object.class);

    public Class<?> getArrayClass();

    public A create(int var1);

    public Object get(A var1, int var2);

    public void set(A var1, int var2, Object var3);

    public int length(A var1);

    public void fill(A var1, int var2, int var3, Object var4);

    public void copy(A var1, int var2, A var3, int var4, int var5);

    public Object getDefaultValue();

    default public void fillRaw(Object array, int offset, int length, Object value) {
        this.fill(array, offset, length, value);
    }

    default public void copyRaw(Object src, int srcPos, Object dest, int destPos, int length) {
        this.copy(src, srcPos, dest, destPos, length);
    }

    default public Object getRaw(Object array, int index) {
        return this.get(array, index);
    }

    default public void setRaw(Object array, int index, Object value) {
        this.set(array, index, value);
    }

    default public void lengthRaw(Object array) {
        this.length(array);
    }

    public static <T> ArrayOpsObject<T> createFor(Class<T> componentType) {
        return new ArrayOpsObject(size -> (Object[])Array.newInstance(componentType, size));
    }

    public static <T> ArrayOpsObject<T> createFor(IntFunction<T[]> arrayConstructor) {
        return new ArrayOpsObject(arrayConstructor);
    }

    public static <T> ArrayOps<T[]> forObjects() {
        ArrayOpsObject<Object> result = OBJECT;
        return result;
    }

    default public byte getByte(A array, int index) {
        return (Byte)this.get(array, index);
    }

    default public void setByte(A array, int index, byte value) {
        this.set(array, index, value);
    }

    default public byte getByteRaw(Object array, int index) {
        return this.getByte(array, index);
    }

    default public void setByteRaw(Object array, int index, byte value) {
        this.setByte(array, index, value);
    }
}

