/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.slice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import org.aksw.commons.io.slice.BufferView;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.io.slice.SliceAccessor;
import org.aksw.commons.io.slice.SliceWithPages;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;
import org.aksw.commons.util.closeable.Disposable;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.commons.util.page.PageUtils;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceAccessorImpl<A>
extends AutoCloseableWithLeakDetectionBase
implements SliceAccessor<A> {
    private static final Logger logger = LoggerFactory.getLogger(SliceAccessorImpl.class);
    protected SliceWithPages<A> slice;
    protected Range<Long> offsetRange;
    protected ConcurrentNavigableMap<Long, RefFuture<BufferView<A>>> claimedPages = new ConcurrentSkipListMap<Long, RefFuture<BufferView<A>>>();
    protected boolean isLocked = false;
    protected Collection<Disposable> evictionGuards = new ArrayList<Disposable>();
    protected int bulkSize = 16;

    public SliceAccessorImpl(SliceWithPages<A> cache) {
        this.slice = cache;
    }

    @Override
    public Slice<A> getSlice() {
        return this.slice;
    }

    public Range<Long> getOffsetRange() {
        return this.offsetRange;
    }

    public SliceWithPages<A> getCache() {
        return this.slice;
    }

    public ConcurrentNavigableMap<Long, RefFuture<BufferView<A>>> getClaimedPages() {
        return this.claimedPages;
    }

    @Override
    public void claimByOffsetRange(long startOffset, long endOffset) {
        long startPageId = this.slice.getPageIdForOffset(startOffset);
        long endPageId = this.slice.getPageIdForOffset(endOffset);
        this.offsetRange = Range.closedOpen((Comparable)Long.valueOf(startOffset), (Comparable)Long.valueOf(endOffset));
        this.claimByPageIdRange(startPageId, endPageId);
    }

    protected synchronized void claimByPageIdRange(long startPageId, long endPageId) {
        this.ensureOpen();
        this.ensureUnlocked();
        NavigableMap prefixPagesToRelease = this.claimedPages.headMap((Object)startPageId, false);
        prefixPagesToRelease.values().forEach(Ref::close);
        prefixPagesToRelease.clear();
        NavigableMap suffixPagesToRelease = this.claimedPages.tailMap((Object)endPageId, false);
        suffixPagesToRelease.values().forEach(Ref::close);
        suffixPagesToRelease.clear();
        for (long i = startPageId; i <= endPageId; ++i) {
            this.claimedPages.computeIfAbsent(i, idx -> {
                if (logger.isTraceEnabled()) {
                    logger.trace("Acquired page item [" + idx + "]");
                }
                RefFuture<BufferView<A>> page = this.slice.getPageForPageId((long)idx);
                return page;
            });
        }
        for (RefFuture page : this.claimedPages.values()) {
            page.await();
        }
    }

    protected NavigableMap<Long, BufferView<A>> computePageMap() {
        return this.claimedPages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            RefFuture refFuture = (RefFuture)e.getValue();
            return (BufferView)refFuture.await();
        }, (u, v) -> {
            throw new RuntimeException("should not happen");
        }, TreeMap::new));
    }

    protected void ensureUnlocked() {
        if (this.isLocked) {
            throw new IllegalStateException("Pages ware already locked - need to be unlocked first");
        }
    }

    @Override
    public void lock() {
        this.ensureUnlocked();
        this.isLocked = true;
    }

    @Override
    public void unlock() {
        this.isLocked = false;
    }

    public void releaseEvictionGuards() {
        if (!this.evictionGuards.isEmpty()) {
            FinallyRunAll action = FinallyRunAll.create();
            this.evictionGuards.forEach(eg -> action.add(() -> ((Disposable)eg).close()));
            this.evictionGuards.clear();
            action.run();
        }
    }

    @Override
    public void releaseAll() {
        if (this.isLocked) {
            this.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Releasing pages: " + String.valueOf(this.claimedPages.keySet()));
        }
        this.claimedPages.values().forEach(Ref::close);
        this.claimedPages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(long offset, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) {
        this.ensureOpen();
        Range totalWriteRange = Range.closedOpen((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(offset + (long)arrLength));
        Preconditions.checkArgument((boolean)this.offsetRange.encloses(totalWriteRange), (Object)("Write range  " + String.valueOf(totalWriteRange) + " is not enclosed by claimed range " + String.valueOf(this.offsetRange)));
        Lock lock = this.slice.getReadWriteLock().writeLock();
        lock.lock();
        try {
            long knownSize = this.slice.getKnownSize();
            int remaining = arrLength;
            while (remaining > 0) {
                long pageId = this.slice.getPageIdForOffset(offset);
                long offsetInPage = this.slice.getIndexInPageForOffset(offset);
                RefFuture currentPageRef = (RefFuture)this.getClaimedPages().get(pageId);
                BufferView buffer = (BufferView)currentPageRef.await();
                long bufferCapacity = buffer.getRangeBuffer().getCapacity();
                long numItemsUntilPageEnd = bufferCapacity - offsetInPage;
                long numItemsUntilPageKnownSize = knownSize < 0L ? Long.MAX_VALUE : knownSize - offset;
                int limit = Math.min(Ints.saturatedCast((long)Math.min(numItemsUntilPageEnd, numItemsUntilPageKnownSize)), remaining);
                Lock contentWriteLock = buffer.getReadWriteLock().writeLock();
                contentWriteLock.lock();
                try {
                    buffer.getRangeBuffer().write(offsetInPage, arrayWithItemsOfTypeT, arrOffset, limit);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    contentWriteLock.unlock();
                }
                remaining -= limit;
                offset += (long)limit;
                arrOffset += limit;
            }
            this.slice.updateMinimumKnownSize(offset);
            this.slice.getLoadedRanges().add(totalWriteRange);
            this.slice.getHasDataCondition().signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int unsafeRead(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        this.ensureOpen();
        Range totalReadRange = Range.closedOpen((Comparable)Long.valueOf(srcOffset), (Comparable)Long.valueOf(srcOffset + (long)length));
        Preconditions.checkArgument((boolean)this.offsetRange.encloses(totalReadRange), (Object)("Read range  " + String.valueOf(totalReadRange) + " is not enclosed by claimed range " + String.valueOf(this.offsetRange)));
        ContiguousSet cset = ContiguousSet.create((Range)totalReadRange, (DiscreteDomain)DiscreteDomain.longs());
        int result = cset.size();
        long startAbs = (Long)cset.first();
        long endAbs = startAbs + (long)result;
        long pageSize = this.slice.getPageSize();
        long startPageId = PageUtils.getPageIndexForOffset((long)startAbs, (long)pageSize);
        long indexInPage = PageUtils.getIndexInPage((long)startAbs, (long)pageSize);
        int remainingInSrc = length;
        long i = startPageId;
        while (remainingInSrc > 0) {
            RefFuture currentPageRef = (RefFuture)this.getClaimedPages().get(i);
            BufferView buffer = (BufferView)currentPageRef.await();
            int remainingInPage = Ints.checkedCast((long)Math.min(pageSize - indexInPage, (long)remainingInSrc));
            buffer.getRangeBuffer().readInto(tgt, tgtOffset, indexInPage, remainingInPage);
            tgtOffset += remainingInPage;
            remainingInSrc -= remainingInPage;
            indexInPage = 0L;
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int blockingRead(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        this.ensureOpen();
        Range totalReadRange = Range.closedOpen((Comparable)Long.valueOf(srcOffset), (Comparable)Long.valueOf(srcOffset + (long)length));
        Preconditions.checkArgument((boolean)this.offsetRange.encloses(totalReadRange), (Object)("Read range  " + String.valueOf(totalReadRange) + " is not enclosed by claimed range " + String.valueOf(this.offsetRange)));
        long currentOffset = srcOffset;
        ReadWriteLock rwl = this.slice.getReadWriteLock();
        Lock readLock = rwl.readLock();
        readLock.lock();
        try {
            int result;
            List failures;
            Range entry;
            block16: {
                RangeSet<Long> loadedRanges = this.slice.getLoadedRanges();
                TreeRangeMap failedRanges = TreeRangeMap.create();
                entry = null;
                failures = null;
                try {
                    long maximumSize = this.slice.getMaximumKnownSize();
                    if (currentOffset >= maximumSize) {
                        result = -1;
                        break block16;
                    }
                    failures = (List)failedRanges.get((Comparable)Long.valueOf(currentOffset));
                    entry = loadedRanges.rangeContaining((Comparable)Long.valueOf(currentOffset));
                    if (entry != null || failures != null) break block16;
                    Lock writeLock = rwl.writeLock();
                    readLock.unlock();
                    writeLock.lock();
                    try {
                        long knownSize;
                        while ((entry = loadedRanges.rangeContaining((Comparable)Long.valueOf(currentOffset))) == null && ((knownSize = this.slice.getMaximumKnownSize()) < 0L || currentOffset < knownSize)) {
                            try {
                                logger.info("Awaiting more data: " + String.valueOf(entry) + " " + currentOffset + " " + knownSize);
                                this.slice.getHasDataCondition().await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    finally {
                        writeLock.unlock();
                        readLock.lock();
                    }
                }
                finally {
                    readLock.unlock();
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new RuntimeException("Attempt to read a range of data marked with an error", (Throwable)failures.get(0));
            }
            if (entry == null) {
                this.close();
                result = -1;
                return result;
            }
            Range range = totalReadRange.intersection(entry);
            ContiguousSet cset = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.longs());
            result = cset.size();
            long startAbs = (Long)cset.first();
            long endAbs = startAbs + (long)result;
            long pageSize = this.slice.getPageSize();
            long startPageId = PageUtils.getPageIndexForOffset((long)startAbs, (long)pageSize);
            long endPageId = PageUtils.getPageIndexForOffset((long)endAbs, (long)pageSize);
            long indexInPage = PageUtils.getIndexInPage((long)startAbs, (long)pageSize);
            int nextTgtOffset = tgtOffset;
            long i = startPageId;
            while (i <= endPageId) {
                long endIndexRaw = i == endPageId ? PageUtils.getIndexInPage((long)endAbs, (long)pageSize) : pageSize;
                int endIndex = Math.toIntExact(endIndexRaw);
                RefFuture currentPageRef = (RefFuture)this.getClaimedPages().get(i);
                BufferView buffer = (BufferView)currentPageRef.await();
                buffer.getRangeBuffer().readInto(tgt, nextTgtOffset, indexInPage, endIndex);
                nextTgtOffset += endIndex;
                indexInPage = 0L;
                ++i;
            }
            return result;
        }
        finally {
            readLock.unlock();
        }
    }

    protected void closeActual() {
        this.releaseEvictionGuards();
        this.releaseAll();
    }

    @Override
    public void addEvictionGuard(RangeSet<Long> ranges) {
        Disposable disposable = this.slice.addEvictionGuard(ranges);
        if (disposable != null) {
            this.evictionGuards.add(disposable);
        }
    }
}

