/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.seekable.impl;

import com.google.common.collect.Range;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.io.seekable.api.SeekableSource;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;

@Deprecated
public class SeekableSourceOverDataStreamSource
implements SeekableSource {
    protected ReadableChannelSource<byte[]> source;
    protected long maxSeekByReadLength;

    public SeekableSourceOverDataStreamSource(ReadableChannelSource<byte[]> source, long maxSeekByReadLength) {
        this.source = source;
        this.maxSeekByReadLength = maxSeekByReadLength;
    }

    @Override
    public boolean supportsAbsolutePosition() {
        return true;
    }

    @Override
    public Seekable get(long pos) throws IOException {
        return new SeekableFromSequentialReaderSource(pos);
    }

    @Override
    public long size() throws IOException {
        return this.source.size();
    }

    class SeekableFromSequentialReaderSource
    extends AutoCloseableWithLeakDetectionBase
    implements Seekable {
        protected ReadableChannel<byte[]> currentReader;
        protected long currentRequestedPos;
        protected long currentActualPos;
        protected byte[] skipBuffer = null;

        public SeekableFromSequentialReaderSource(long currentPos) {
            this.currentRequestedPos = currentPos;
        }

        @Override
        public boolean isOpen() {
            return !this.isClosed;
        }

        @Override
        public Seekable clone() {
            return new SeekableFromSequentialReaderSource(this.currentActualPos);
        }

        protected void syncPos() throws IOException {
            if (this.currentReader != null) {
                int delta = Ints.saturatedCast((long)(this.currentRequestedPos - this.currentActualPos));
                if (delta > 0 && (long)delta < SeekableSourceOverDataStreamSource.this.maxSeekByReadLength && delta != Integer.MAX_VALUE) {
                    this.skip(delta);
                } else if (this.currentRequestedPos != this.currentActualPos) {
                    this.currentReader.close();
                    this.currentReader = null;
                }
            }
        }

        @Override
        public long getPos() throws IOException {
            return this.currentRequestedPos;
        }

        @Override
        public void setPos(long requestedPos) throws IOException {
            this.currentRequestedPos = requestedPos;
        }

        @Override
        public void posToStart() throws IOException {
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
                this.currentRequestedPos = -1L;
            }
        }

        @Override
        public void posToEnd() throws IOException {
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
                this.currentRequestedPos = Long.MAX_VALUE;
            }
        }

        @Override
        public boolean isPosBeforeStart() throws IOException {
            return this.currentRequestedPos < 0L;
        }

        @Override
        public boolean isPosAfterEnd() throws IOException {
            long size = this.size();
            boolean result = this.currentRequestedPos == Long.MAX_VALUE || size >= 0L && this.currentRequestedPos >= size;
            return result;
        }

        protected int skip(int len) throws IOException {
            if (this.skipBuffer == null) {
                this.skipBuffer = new byte[4096];
            }
            int sbs = this.skipBuffer.length;
            int remaining = len;
            int contrib = 0;
            while (contrib >= 0 && (remaining -= contrib) > 0 && (contrib = this.currentReader.read(this.skipBuffer, 0, Math.min(remaining, sbs))) >= 0) {
            }
            int result = len - remaining;
            this.currentActualPos += (long)result;
            this.currentRequestedPos = this.currentActualPos;
            return result;
        }

        @Override
        public int checkNext(int len, boolean changePos) throws IOException {
            int result;
            long size = this.size();
            if (size >= 0L) {
                long available = size - this.currentRequestedPos;
                result = Math.max(Ints.saturatedCast((long)Math.min((long)len, available)), 0);
                if (changePos) {
                    this.currentRequestedPos += (long)result;
                }
            } else {
                long savedPos = this.currentActualPos;
                throw new UnsupportedOperationException("unknown size is not yet supported");
            }
            return result;
        }

        @Override
        public int checkPrev(int len, boolean changePos) throws IOException {
            int result = Ints.saturatedCast((long)Math.min(this.currentRequestedPos, (long)len));
            if (changePos) {
                this.currentRequestedPos -= (long)result;
            }
            return result;
        }

        @Override
        public String readString(int len) throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(len);
            int n = this.read(buf);
            byte[] bytes = buf.array();
            String result = new String(bytes, 0, n < 0 ? 0 : n, StandardCharsets.UTF_8);
            return result;
        }

        protected int read(byte[] dst, int offset, int length) throws IOException {
            int result;
            this.syncPos();
            if (this.currentReader == null) {
                this.currentReader = SeekableSourceOverDataStreamSource.this.source.newReadableChannel((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.currentRequestedPos)));
                this.currentActualPos = this.currentRequestedPos;
            }
            this.currentActualPos = (result = this.currentReader.read(dst, offset, length)) >= 0 ? (this.currentActualPos += (long)result) : Long.MAX_VALUE;
            this.currentRequestedPos = this.currentActualPos;
            return result;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int result;
            int n = dst.remaining();
            if (dst.hasArray()) {
                int dstPos = Ints.checkedCast((long)dst.position());
                result = this.read(dst.array(), dstPos, n);
                if (result > 0) {
                    dst.position(dstPos + result);
                }
            } else {
                byte[] buf = new byte[n];
                result = this.read(buf, 0, n);
                if (result > 0) {
                    dst.put(buf, 0, result);
                }
            }
            return result;
        }

        public void closeActual() throws IOException {
            if (this.currentReader != null) {
                this.currentReader.close();
            }
        }

        @Override
        public long size() throws IOException {
            long result = SeekableSourceOverDataStreamSource.this.size();
            return result;
        }
    }
}

