/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.seekable.api;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public interface Seekable
extends ReadableByteChannel {
    public Seekable clone();

    default public Seekable cloneObject() {
        return this.clone();
    }

    public long getPos() throws IOException;

    public void setPos(long var1) throws IOException;

    public void posToStart() throws IOException;

    public void posToEnd() throws IOException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public byte get(int relPos) throws IOException {
        byte result;
        if (relPos > 0) {
            if (!this.nextPos(relPos)) throw new RuntimeException("No data " + relPos + " byte from current position " + this.getPos());
            result = this.get();
            this.prevPos(relPos);
            return result;
        } else {
            if (relPos >= 0) return this.get();
            int tmp = -relPos;
            if (!this.prevPos(tmp)) throw new RuntimeException("No data " + relPos + " byte from current position " + this.getPos());
            result = this.get();
            this.nextPos(tmp);
        }
        return result;
    }

    default public byte get() throws IOException {
        long pos = this.getPos();
        byte[] arr = new byte[1];
        this.read(ByteBuffer.wrap(arr));
        byte result = arr[0];
        this.setPos(pos);
        return result;
    }

    public boolean isPosBeforeStart() throws IOException;

    public boolean isPosAfterEnd() throws IOException;

    default public boolean nextPos(int len) throws IOException {
        boolean result;
        int available = this.checkNext(len, false);
        boolean bl = result = available == len;
        if (result) {
            this.checkNext(len, true);
        }
        return result;
    }

    public int checkNext(int var1, boolean var2) throws IOException;

    default public boolean prevPos(int len) throws IOException {
        boolean result;
        int r = this.checkPrev(len, false);
        boolean bl = result = r == len;
        if (result) {
            this.checkPrev(len, true);
        }
        return result;
    }

    public int checkPrev(int var1, boolean var2) throws IOException;

    default public boolean deltaPos(int delta) throws IOException {
        boolean result = delta > 0 ? this.nextPos(delta) : (delta < 0 ? this.prevPos(-delta) : true);
        return result;
    }

    default public int peekNextBytes(byte[] dst, int offset, int len) throws IOException {
        int n;
        if (!this.isPosAfterEnd()) {
            for (n = 0; n < len; ++n) {
                byte c;
                dst[offset + n] = c = this.get();
                if (!this.nextPos(1)) break;
            }
        }
        this.prevPos(n);
        return n;
    }

    default public boolean posToNext(byte delimiter) throws IOException {
        boolean isPosAfterEnd;
        boolean result = false;
        while (!(isPosAfterEnd = this.isPosAfterEnd())) {
            byte b = this.get();
            if (b == delimiter) {
                result = true;
                break;
            }
            boolean posChanged = this.nextPos(1);
            if (posChanged) continue;
            this.posToEnd();
            break;
        }
        return result;
    }

    default public int posToNext(byte delimiter, boolean changePos) throws IOException {
        int result;
        int n;
        long startPos = this.getPos();
        byte[] buffer = new byte[1024];
        int delta = 0;
        boolean foundMatch = false;
        block0: while ((n = this.read(ByteBuffer.wrap(buffer))) >= 0) {
            for (int i = 0; i < n; ++i) {
                if (buffer[i] != delimiter) continue;
                delta += i;
                foundMatch = true;
                break block0;
            }
            delta += n;
        }
        if (foundMatch) {
            result = delta;
            this.setPos(startPos + (long)delta);
        } else {
            if (!changePos) {
                this.setPos(startPos);
            }
            result = -(delta + 1);
        }
        return result;
    }

    default public boolean posToPrev(byte delimiter) throws IOException {
        boolean isBeforeStart;
        boolean result = false;
        while (!(isBeforeStart = this.isPosBeforeStart())) {
            byte b = this.get();
            if (b == delimiter) {
                result = true;
                break;
            }
            boolean posChanged = this.prevPos(1);
            if (posChanged) continue;
            this.posToStart();
            break;
        }
        return result;
    }

    @Override
    default public int read(ByteBuffer dst) throws IOException {
        throw new RuntimeException("This code is bugged because it does not return -1 on end");
    }

    public String readString(int var1) throws IOException;

    default public int compareToPrefix(byte[] prefix) throws IOException {
        int n = prefix.length;
        byte[] buf = new byte[n];
        long pos = this.getPos();
        ByteBuffer bb = ByteBuffer.wrap(buf);
        while (this.read(bb) != -1) {
        }
        int totalRead = bb.position();
        int result = Seekable.compareArrays(buf, prefix);
        this.setPos(pos);
        return result;
    }

    public static int compareArrays(byte[] a, byte[] b) {
        int n = Math.min(a.length, b.length);
        int result = 0;
        for (int i = 0; i < n && result == 0; ++i) {
            byte x = a[i];
            byte y = b[i];
            result = Byte.compare(x, y);
        }
        return result;
    }

    default public long binarySearch(long min, long max, byte delimiter, byte[] prefix) throws IOException {
        long result;
        long middlePos = (min + max) / 2L;
        this.setPos(middlePos);
        if (this.isPosAfterEnd()) {
            return Long.MIN_VALUE;
        }
        if (middlePos != -1L) {
            this.posToNext(delimiter);
        }
        long delimPos = this.getPos();
        this.nextPos(1);
        if (min >= max) {
            return Long.MIN_VALUE;
        }
        int cmp = this.compareToPrefix(prefix);
        if (cmp == 0) {
            result = delimPos;
        } else if (cmp < 0) {
            boolean failedNext;
            this.setPos(delimPos);
            this.checkNext(1, true);
            long nextDelimPos = this.getPos();
            boolean bl = failedNext = delimPos == nextDelimPos;
            result = failedNext ? Long.MIN_VALUE : this.binarySearch(nextDelimPos, max, delimiter, prefix);
        } else {
            result = delimPos >= max ? Long.MIN_VALUE : this.binarySearch(min, delimPos - 1L, delimiter, prefix);
        }
        return result;
    }

    @Override
    public void close() throws IOException;

    default public long size() throws IOException {
        return -1L;
    }
}

