/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.array.ArrayReadable;
import org.aksw.commons.io.buffer.plain.BufferOverArray;
import org.aksw.commons.io.input.CharSequenceOverSeekableReadableChannelOfBytes;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.SeekableByteChannelAdapter;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelDecoratorBase;
import org.aksw.commons.io.input.SeekableReadableChannelOmitBlockMarker;
import org.aksw.commons.io.input.SeekableReadableChannelOverBuffer;
import org.aksw.commons.io.input.SeekableReadableChannelOverNio;
import org.aksw.commons.io.input.SeekableReadableChannelOverReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelWithOffset;

public class SeekableReadableChannels {
    public static <A, X extends SeekableReadableChannel<A>> SeekableReadableChannel<A> omitBlockMarker(X delegate) {
        return new SeekableReadableChannelOmitBlockMarker(delegate);
    }

    public static <A> SeekableReadableChannel<A> shiftOffset(SeekableReadableChannel<A> dataStream, long offset) {
        return new SeekableReadableChannelWithOffset(dataStream, offset);
    }

    public static SeekableReadableChannel<byte[]> wrap(SeekableByteChannel nioChannel) {
        return new SeekableReadableChannelOverNio<SeekableByteChannel>(nioChannel);
    }

    public static SeekableByteChannel adapt(SeekableReadableChannel<byte[]> channel) {
        return new SeekableByteChannelAdapter<SeekableReadableChannel<byte[]>>(channel);
    }

    public static <A> SeekableReadableChannelOverBuffer<A> newChannel(ArrayReadable<A> arrayReadable) {
        return SeekableReadableChannels.newChannel(arrayReadable, 0L);
    }

    public static <A> SeekableReadableChannelOverBuffer<A> newChannel(ArrayReadable<A> arrayReadable, long pos) {
        return new SeekableReadableChannelOverBuffer<A>(arrayReadable, pos);
    }

    public static <A> SeekableReadableChannelOverBuffer<A> empty(ArrayOps<A> arrayOps) {
        return SeekableReadableChannels.newChannel(BufferOverArray.create(arrayOps, false), 0L);
    }

    public static <A> SeekableReadableChannelOverBuffer<A> of(ArrayOps<A> arrayOps, A array) {
        return SeekableReadableChannels.newChannel(BufferOverArray.create(arrayOps, array), 0L);
    }

    public static <A> SeekableReadableChannelOverBuffer<A> of(ArrayOps<A> arrayOps, A array, int pos) {
        return SeekableReadableChannels.newChannel(BufferOverArray.create(arrayOps, array), pos);
    }

    public static <A> SeekableReadableChannel<A> wrapForwardSeekable(ReadableChannel<A> channel, long basePos) {
        return new SeekableReadableChannelOverReadableChannel<A>(channel, basePos);
    }

    public static <T> SeekableReadableChannel<T> closeShield(SeekableReadableChannel<T> in) {
        Objects.requireNonNull(in);
        return new SeekableReadableChannelDecoratorBase<T, SeekableReadableChannel<T>>(in){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static CharSequence asCharSequence(SeekableReadableChannel<byte[]> channel) {
        long pos;
        Objects.requireNonNull(channel);
        try {
            pos = channel.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SeekableReadableChannel<byte[]> shifted = SeekableReadableChannels.shiftOffset(channel, pos);
        return SeekableReadableChannels.asCharSequence(shifted, Integer.MAX_VALUE);
    }

    public static CharSequence asCharSequence(SeekableReadableChannel<byte[]> channel, int length) {
        return new CharSequenceOverSeekableReadableChannelOfBytes(channel, length);
    }

    public static long position(SeekableReadableChannel<?> channel) {
        long result;
        try {
            result = channel.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

