/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.util.Objects;
import org.aksw.commons.io.input.ChannelMonitor2;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelDecoratorBase;

public class SeekableReadableChannelWithMonitor<A, X extends SeekableReadableChannel<A>>
extends SeekableReadableChannelDecoratorBase<A, X> {
    protected ChannelMonitor2 monitor;
    protected long cachedPos;
    protected long relativeStart;
    protected long readLength;
    protected volatile long readCounter = 0L;

    public SeekableReadableChannelWithMonitor(X delegate, ChannelMonitor2 monitor) {
        super(delegate);
        this.monitor = Objects.requireNonNull(monitor);
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        long startTimestamp = System.nanoTime();
        int result = super.read(array, position, length);
        if (result > 0) {
            long endTimestamp = System.nanoTime();
            long duration = endTimestamp - startTimestamp;
            long nextStart = this.relativeStart + (long)result;
            this.monitor.incReadCounter();
            this.monitor.addReadAmount(result);
            this.relativeStart = nextStart;
        }
        return result;
    }

    @Override
    public void position(long pos) throws IOException {
        this.cachedPos = pos;
        super.position(pos);
    }
}

