/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.array.ArrayReadable;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelBase;

public class SeekableReadableChannelOverBuffer<A>
extends SeekableReadableChannelBase<A> {
    protected ArrayReadable<A> buffer;
    protected long offset;

    public SeekableReadableChannelOverBuffer(ArrayReadable<A> buffer, long offset) {
        this.buffer = buffer;
        this.offset = offset;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.buffer.getArrayOps();
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        int n = this.buffer.readInto(array, position, this.offset, length);
        if (n >= 0) {
            this.offset += (long)n;
        }
        return n;
    }

    @Override
    public SeekableReadableChannel<A> cloneObject() {
        return new SeekableReadableChannelOverBuffer<A>(this.buffer, this.offset);
    }

    @Override
    public long position() {
        return this.offset;
    }

    @Override
    public void position(long position) {
        this.offset = position;
    }
}

