/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import org.aksw.commons.io.buffer.ring.RingBufferForBytes;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelDecoratorBase;
import org.aksw.commons.io.input.ReadableSource;

public class ReadableChannelWithSkipDelimiter<T extends ReadableChannel<byte[]>>
extends ReadableChannelDecoratorBase<byte[], T> {
    protected final byte delimiter;
    protected RingBufferForBytes ringBuffer;
    protected int initialSkipCount;
    protected int remainingSkipCount;

    public ReadableChannelWithSkipDelimiter(T delegate, byte delimiter, int initialSkipCount) {
        super(delegate);
        this.delimiter = delimiter;
        this.initialSkipCount = initialSkipCount;
        this.remainingSkipCount = initialSkipCount;
        this.ringBuffer = new RingBufferForBytes(8192);
    }

    @Override
    public int read(byte[] array, int position, int length) throws IOException {
        int result = 0;
        while (this.remainingSkipCount > 0) {
            int i;
            int n;
            if (this.ringBuffer.isEmpty() && (n = this.ringBuffer.fill((ReadableSource)((Object)this.getDelegate()), this.ringBuffer.length())) == 0) {
                result = -1;
                break;
            }
            int availableData = this.ringBuffer.available();
            for (i = 0; i < availableData; ++i) {
                byte c = this.ringBuffer.get(i);
                if (c != this.delimiter) continue;
                ++i;
                --this.remainingSkipCount;
                break;
            }
            this.ringBuffer.skip(i);
        }
        result = !this.ringBuffer.isEmpty() ? this.ringBuffer.read(array, position, length) : ((ReadableChannel)this.getDelegate()).read(array, position, length);
        return result;
    }
}

