/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.util.function.Predicate;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelWithCounter;

public class ReadableChannelWithConditionalBound<A, X extends ReadableChannel<A>>
extends ReadableChannelWithCounter<A, X> {
    protected Predicate<? super ReadableChannelWithConditionalBound<A, X>> testForEof;
    protected boolean isInEofState = false;

    public ReadableChannelWithConditionalBound(X delegate, Predicate<? super ReadableChannelWithConditionalBound<A, X>> testForEof) {
        super(delegate);
        this.testForEof = testForEof;
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        int result;
        boolean bl = this.isInEofState = this.isInEofState || this.testForEof.test(this);
        if (this.isInEofState) {
            result = -1;
        } else {
            result = super.read(array, position, length);
            if (result < 0) {
                this.isInEofState = true;
            }
        }
        return result;
    }
}

