/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfig;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfigImpl;
import org.aksw.commons.io.cache.AdvancedRangeCacheImpl;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannelSourceOverPath;
import org.aksw.commons.io.input.ReadableChannelSourceOverStreamFactory;
import org.aksw.commons.io.input.SourceSplit;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.io.slice.SliceInMemoryCache;
import org.aksw.commons.io.slice.SliceWithPagesSyncToDisk;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathStr;
import org.aksw.commons.store.object.key.api.ObjectStore;
import org.aksw.commons.store.object.key.impl.KryoUtils;
import org.aksw.commons.store.object.key.impl.ObjectStoreImpl;
import org.aksw.commons.store.object.path.api.ObjectSerializer;
import org.aksw.commons.store.object.path.impl.ObjectSerializerKryo;

public class ReadableChannelSources {
    public static ReadableChannelSource<byte[]> of(java.nio.file.Path path) throws IOException {
        return ReadableChannelSources.of(path, true);
    }

    public static <T> ReadableChannelSource<T[]> ofStreamFactory(Supplier<Stream<T>> streamFactory) {
        return new ReadableChannelSourceOverStreamFactory<T>(ArrayOps.forObjects(), streamFactory);
    }

    public static ReadableChannelSource<byte[]> of(java.nio.file.Path path, boolean cacheSize) throws IOException {
        long cachedSize = cacheSize ? Files.size(path) : -1L;
        return new ReadableChannelSourceOverPath(path, cachedSize);
    }

    public static <A> ReadableChannelSource<A> cacheInMemory(ReadableChannelSource<A> source, int pageSize, int maxPages, long maxRequestSize) {
        return ReadableChannelSources.cache(source, SliceInMemoryCache.create(source.getArrayOps(), pageSize, maxPages), AdvancedRangeCacheConfigImpl.newDefaultsForObjects(maxRequestSize));
    }

    public static <A> ReadableChannelSource<A> cache(ReadableChannelSource<A> source, java.nio.file.Path cacheBaseFolder, String cacheEntryId, AdvancedRangeCacheConfig cacheConfig) {
        PathStr relPath = PathStr.parse((String)cacheEntryId);
        if (relPath.isAbsolute()) {
            throw new IllegalArgumentException("Cache entries must map to relative paths");
        }
        return ReadableChannelSources.cache(source, cacheBaseFolder, (Path<String>)relPath, cacheConfig);
    }

    public static <A> ReadableChannelSource<A> cache(ReadableChannelSource<A> source, java.nio.file.Path cacheBaseFolder, Path<String> cacheEntryId, AdvancedRangeCacheConfig cacheConfig) {
        return ReadableChannelSources.cache(source, cacheBaseFolder, cacheEntryId, cacheConfig, null);
    }

    public static <A> ReadableChannelSource<A> cache(ReadableChannelSource<A> source, java.nio.file.Path cacheBaseFolder, Path<String> cacheEntryId, AdvancedRangeCacheConfig cacheConfig, Consumer<Kryo> customRegistrator) {
        ObjectStore objectStore = ObjectStoreImpl.create((java.nio.file.Path)cacheBaseFolder, (ObjectSerializer)ObjectSerializerKryo.create((KryoPool)KryoUtils.createKryoPool(customRegistrator)));
        return ReadableChannelSources.cache(source, objectStore, cacheEntryId, cacheConfig);
    }

    public static <A> ReadableChannelSource<A> cache(ReadableChannelSource<A> source, ObjectStore objectStore, Path<String> cacheEntryId, AdvancedRangeCacheConfig cacheConfig) {
        SliceWithPagesSyncToDisk slice = SliceWithPagesSyncToDisk.create(source.getArrayOps(), objectStore, cacheEntryId, cacheConfig.getPageSize(), cacheConfig.getTerminationDelay());
        return ReadableChannelSources.cache(source, slice, cacheConfig);
    }

    public static <A> ReadableChannelSource<A> cache(ReadableChannelSource<A> source, Slice<A> slice, AdvancedRangeCacheConfig cacheConfig) {
        AdvancedRangeCacheImpl result = AdvancedRangeCacheImpl.newBuilder().setDataSource(source).setWorkerBulkSize(cacheConfig.getInternalWorkerSize()).setSlice(slice).setRequestLimit(cacheConfig.getMaxRequestSize()).setTerminationDelay(cacheConfig.getTerminationDelay()).build();
        return result;
    }

    public static <A, T extends ReadableChannelSource<A>> Stream<SourceSplit<A, T>> splitByCount(T source, int splitCount) throws IOException {
        long sourceSize = source.size();
        long splitSize = sourceSize / (long)splitCount;
        List<Integer> splitIds = IntStream.range(0, splitCount).boxed().toList();
        return splitIds.parallelStream().map(splitId -> {
            long start = (long)splitId.intValue() * splitSize;
            boolean isLastSplit = splitId == splitCount - 1;
            long end = isLastSplit ? sourceSize : start + splitSize;
            return new SourceSplit(source, start, end);
        });
    }

    public static <A, T extends ReadableChannelSource<A>> Stream<SourceSplit<A, T>> splitBySize(T source, long splitSize) throws IOException {
        long sourceSize = source.size();
        int evenSplitCount = (int)(sourceSize / splitSize);
        int splitCount = evenSplitCount + 1;
        List<Integer> splitIds = IntStream.range(0, splitCount).boxed().toList();
        return splitIds.parallelStream().map(splitId -> {
            long start = (long)splitId.intValue() * splitSize;
            boolean isLastSplit = splitId == splitCount - 1;
            long end = isLastSplit ? sourceSize : start + splitSize;
            return new SourceSplit(source, start, end);
        });
    }
}

