/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannels;

public class ReadableChannelSourceOverStreamFactory<T>
implements ReadableChannelSource<T[]> {
    protected ArrayOps<T[]> arrayOps;
    protected Supplier<Stream<T>> streamFactory;

    public ReadableChannelSourceOverStreamFactory(ArrayOps<T[]> arrayOps, Supplier<Stream<T>> streamFactory) {
        this.arrayOps = arrayOps;
        this.streamFactory = streamFactory;
    }

    @Override
    public ReadableChannel<T[]> newReadableChannel(long offset, long end) throws IOException {
        Stream<T> stream = this.streamFactory.get();
        stream = stream.skip(offset);
        if (end != Long.MAX_VALUE) {
            long delta = end - offset;
            stream = stream.limit(delta);
        }
        return ReadableChannels.wrap(stream, this.arrayOps);
    }

    @Override
    public ArrayOps<T[]> getArrayOps() {
        return this.arrayOps;
    }

    @Override
    public long size() throws IOException {
        return -1L;
    }
}

