/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelDecoratorBase;

public class ReadableChannelLocking<A, X extends ReadableChannel<A>>
extends ReadableChannelDecoratorBase<A, X> {
    protected ReadWriteLock rwl = new ReentrantReadWriteLock();

    public ReadableChannelLocking(X delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(A array, int position, int length) throws IOException {
        int result;
        Lock readLock = this.rwl.readLock();
        try {
            readLock.lock();
            result = super.read(array, position, length);
        }
        finally {
            readLock.unlock();
        }
        return result;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.rwl;
    }
}

