/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.collect.Range;
import java.io.IOException;
import org.aksw.commons.io.buffer.array.HasArrayOps;
import org.aksw.commons.io.input.ReadableChannel;

public interface ReadableChannelFactory<A>
extends HasArrayOps<A> {
    default public ReadableChannel<A> newReadableChannel() throws IOException {
        return this.newReadableChannel(0L);
    }

    default public ReadableChannel<A> newReadableChannel(long offset) throws IOException {
        return this.newReadableChannel((Range<Long>)Range.atLeast((Comparable)Long.valueOf(offset)));
    }

    default public ReadableChannel<A> newReadableChannel(Range<Long> range) throws IOException {
        long lowerEndpoint = range.hasLowerBound() ? (Long)range.lowerEndpoint() : Long.MIN_VALUE;
        long upperEndpoint = range.hasUpperBound() ? (Long)range.upperEndpoint() : Long.MAX_VALUE;
        return this.newReadableChannel(lowerEndpoint, upperEndpoint);
    }

    public ReadableChannel<A> newReadableChannel(long var1, long var3) throws IOException;
}

