/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.util.range.PageHelper;
import org.apache.commons.lang3.ArrayUtils;

public class CharSequenceOverSeekableReadableChannelOfBytes
implements CharSequence,
PageHelper {
    protected SeekableReadableChannel<byte[]> seekable;
    protected int length;
    protected int pageSize = 32768;
    private static final int DFT_CACHE_SIZE_MAX = 5;
    protected LoadingCache<Long, byte[]> cache;
    protected int recentOffset = Integer.MAX_VALUE;
    protected byte[] recentBuffer = null;

    public CharSequenceOverSeekableReadableChannelOfBytes(SeekableReadableChannel<byte[]> seekable) {
        this(seekable, Integer.MAX_VALUE);
    }

    public CharSequenceOverSeekableReadableChannelOfBytes(SeekableReadableChannel<byte[]> seekable, int length) {
        this.seekable = seekable;
        this.length = length;
        this.cache = CacheBuilder.newBuilder().maximumSize(5L).build((CacheLoader)new CacheLoader<Long, byte[]>(){

            public byte[] load(Long key) throws Exception {
                return CharSequenceOverSeekableReadableChannelOfBytes.this.loadPage(key);
            }
        });
    }

    public long getPageSize() {
        return this.pageSize;
    }

    protected byte[] loadPage(long pageId) throws IOException {
        long offset = this.getPageOffsetForPageId(pageId);
        this.seekable.position(offset);
        byte[] result = new byte[this.pageSize];
        int actualSize = ReadableChannels.readFully(this.seekable, result, 0, this.pageSize);
        if (actualSize != this.pageSize) {
            result = ArrayUtils.subarray((byte[])result, (int)0, (int)actualSize);
        }
        return result;
    }

    protected byte[] getBufferForPageId(long pageId) {
        byte[] result;
        try {
            result = (byte[])this.cache.get((Object)pageId);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        int result;
        if (index >= this.length) {
            result = 65535;
        } else {
            int idx;
            if (this.recentBuffer == null || index < this.recentOffset || index >= this.recentOffset + this.pageSize) {
                long pageId = this.getPageIdForOffset(index);
                this.recentOffset = (int)this.getPageOffsetForPageId(pageId);
                this.recentBuffer = this.getBufferForPageId(pageId);
            }
            result = (idx = index - this.recentOffset) < this.recentBuffer.length ? (int)this.recentBuffer[idx] : 65535;
        }
        return (char)result;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }
}

