/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class ChannelMonitor {
    protected RangeMap<Long, RangeTracker> trackedReads = TreeRangeMap.create();

    public RangeMap<Long, RangeTracker> getTrackedReads() {
        return this.trackedReads;
    }

    public synchronized void submitReadStats(long readStartPos, long readEndPos, int readLength, long durationNanos) {
        if (readLength > 0) {
            RangeTracker contribution = new RangeTracker(readLength, readLength, durationNanos, 1L);
            Range span = Range.openClosed((Comparable)Long.valueOf(readStartPos), (Comparable)Long.valueOf(readEndPos));
            RangeMap subMap = this.trackedReads.subRangeMap(span);
            subMap.asMapOfRanges().values().forEach(tracker -> tracker.add(contribution));
            TreeRangeSet rangeSet = TreeRangeSet.create(subMap.asMapOfRanges().keySet());
            RangeSet gaps = rangeSet.complement().subRangeSet(span);
            gaps.asRanges().forEach(range -> this.trackedReads.put(range, (Object)contribution.clone()));
        }
    }

    public void dumpJson(OutputStream out) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (JsonWriter w = gson.newJsonWriter((Writer)new OutputStreamWriter(out));){
            w.beginArray();
            for (Map.Entry e : this.trackedReads.asMapOfRanges().entrySet()) {
                w.beginObject();
                w.name("offset");
                w.value((Number)((Object)((Range)e.getKey()).lowerEndpoint()));
                w.name("length");
                w.value((long)((RangeTracker)e.getValue()).getMaxReadLength());
                w.endObject();
            }
            w.endArray();
        }
    }

    public class RangeTracker {
        protected long totalDurationNanos;
        protected int minReadLength;
        protected int maxReadLength;
        protected long readCount;

        public RangeTracker(int readLength, long totalDurationNanos) {
            this(readLength, readLength, totalDurationNanos, 1L);
        }

        public RangeTracker(int minReadLength, int maxReadLength, long totalDurationNanos, long readCount) {
            this.totalDurationNanos = totalDurationNanos;
            this.minReadLength = minReadLength;
            this.maxReadLength = maxReadLength;
            this.readCount = readCount;
        }

        public long getTotalDurationNanos() {
            return this.totalDurationNanos;
        }

        public int getMinReadLength() {
            return this.minReadLength;
        }

        public int getMaxReadLength() {
            return this.maxReadLength;
        }

        public long getReadCount() {
            return this.readCount;
        }

        public void add(RangeTracker contrib) {
            this.totalDurationNanos += contrib.totalDurationNanos;
            this.maxReadLength = Math.max(this.maxReadLength, contrib.maxReadLength);
            this.minReadLength = this.minReadLength == -1 ? contrib.minReadLength : Math.min(this.minReadLength, contrib.minReadLength);
            ++this.readCount;
        }

        protected RangeTracker clone() {
            return new RangeTracker(this.minReadLength, this.maxReadLength, this.totalDurationNanos, this.readCount);
        }
    }
}

