/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.cache;

import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.cache.RangeRequestWorkerImpl;
import org.aksw.commons.io.cache.ReadableChannelOverSliceWithCache;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.util.slot.Slot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedRangeCacheImpl<T>
implements ReadableChannelSource<T> {
    private static final Logger logger = LoggerFactory.getLogger(AdvancedRangeCacheImpl.class);
    protected ReadableChannelSource<T> dataSource;
    protected Slice<T> slice;
    protected ReentrantLock workerCreationLock = new ReentrantLock();
    protected Set<RangeRequestWorkerImpl<T>> executors = Collections.synchronizedSet(Sets.newIdentityHashSet());
    protected long readBeforeSize;
    protected long requestLimit;
    protected Duration terminationDelay;
    protected int maxReadAheadItemCount;
    protected int workerBulkSize;
    protected ExecutorService executorService;

    public AdvancedRangeCacheImpl(ReadableChannelSource<T> dataSource, Slice<T> slice, long requestLimit, int workerBulkSize, Duration terminationDelay, int maxReadAheadItemCount, ExecutorService executorService) {
        this.dataSource = dataSource;
        this.slice = slice;
        this.requestLimit = requestLimit;
        this.workerBulkSize = workerBulkSize;
        this.terminationDelay = terminationDelay;
        this.maxReadAheadItemCount = maxReadAheadItemCount;
        this.executorService = executorService;
    }

    @Override
    public ArrayOps<T> getArrayOps() {
        return this.slice.getArrayOps();
    }

    public ReadableChannelSource<T> getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        long result = this.slice.getKnownSize();
        if (result == -1L) {
            try {
                result = this.dataSource.size();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (result >= 0L) {
                Lock lock = this.slice.getReadWriteLock().writeLock();
                lock.lock();
                try {
                    this.slice.updateMinimumKnownSize(result);
                    this.slice.updateMaximumKnownSize(result);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return result;
    }

    public Slice<T> getSlice() {
        return this.slice;
    }

    public Set<RangeRequestWorkerImpl<T>> getExecutors() {
        return this.executors;
    }

    public Lock getExecutorCreationReadLock() {
        return this.workerCreationLock;
    }

    public Map.Entry<RangeRequestWorkerImpl<T>, Slot<Long>> newExecutor(long offset, long initialLength) {
        RangeRequestWorkerImpl worker = new RangeRequestWorkerImpl(this, offset, this.requestLimit, this.workerBulkSize, this.terminationDelay);
        Slot<Long> slot = worker.newDemandSlot();
        slot.set((Object)(offset + initialLength));
        this.executors.add(worker);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("New worker created with initial schedule of offset %1$d and length %2$d", offset, initialLength));
        }
        this.executorService.submit(worker);
        return new AbstractMap.SimpleEntry<RangeRequestWorkerImpl<T>, Slot<Long>>(worker, slot);
    }

    void removeExecutor(RangeRequestWorkerImpl<T> worker) {
        this.executors.remove(worker);
    }

    @Override
    public ReadableChannel<T> newReadableChannel(Range<Long> range) {
        ReadableChannelOverSliceWithCache result = new ReadableChannelOverSliceWithCache(this, range, this.maxReadAheadItemCount);
        return result;
    }

    public static <A> Builder<A> newBuilder() {
        return new Builder();
    }

    public static class Builder<A> {
        protected ReadableChannelSource<A> dataSource;
        protected Slice<A> slice;
        protected int workerBulkSize;
        protected long requestLimit;
        protected Duration terminationDelay;
        protected int maxReadAheadItemCount;
        protected ExecutorService executorService;

        public ReadableChannelSource<A> getDataSource() {
            return this.dataSource;
        }

        public Builder<A> setDataSource(ReadableChannelSource<A> dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Slice<A> getSlice() {
            return this.slice;
        }

        public Builder<A> setSlice(Slice<A> slice) {
            this.slice = slice;
            return this;
        }

        public long getRequestLimit() {
            return this.requestLimit;
        }

        public Builder<A> setRequestLimit(long requestLimit) {
            this.requestLimit = requestLimit;
            return this;
        }

        public int getWorkerBulkSize() {
            return this.workerBulkSize;
        }

        public Builder<A> setWorkerBulkSize(int workerBulkSize) {
            this.workerBulkSize = workerBulkSize;
            return this;
        }

        public Duration getTerminationDelay() {
            return this.terminationDelay;
        }

        public Builder<A> setTerminationDelay(Duration terminationDelay) {
            this.terminationDelay = terminationDelay;
            return this;
        }

        public int getMaxReadAheadItemCount() {
            return this.maxReadAheadItemCount;
        }

        public Builder<A> setMaxReadAheadItemCount(int maxReadAheadItemCount) {
            this.maxReadAheadItemCount = maxReadAheadItemCount;
            return this;
        }

        public Builder<A> setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AdvancedRangeCacheImpl<A> build() {
            ExecutorService finalExecutorService = this.executorService != null ? this.executorService : MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool()));
            return new AdvancedRangeCacheImpl<A>(this.dataSource, this.slice, this.requestLimit, this.workerBulkSize, this.terminationDelay, this.maxReadAheadItemCount, finalExecutorService);
        }
    }
}

