/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.ring;

import java.io.IOException;
import java.util.Objects;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.ReadableSource;

public abstract class RingBufferBase<A>
implements ReadableSource<A> {
    protected A buffer;
    protected int bufferLen;
    protected int start;
    protected int end;
    protected boolean isEmpty;

    public RingBufferBase(A buffer) {
        this(buffer, 0, 0, true);
    }

    public RingBufferBase(A buffer, int start, int end, boolean isEmpty) {
        this.buffer = Objects.requireNonNull(buffer);
        this.bufferLen = this.getArrayOps().length(buffer);
        this.start = start;
        this.end = end;
        this.isEmpty = isEmpty;
        if (isEmpty && start != end) {
            throw new IllegalArgumentException("When setting isEmpty=true then it must hold that start==end");
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public int fill(ReadableSource<A> source, int targetAmount) throws IOException {
        int contrib;
        int result = 0;
        while (this.available() < targetAmount && (contrib = this.fill(source)) != 0) {
            result += contrib;
        }
        return result;
    }

    public int appendCapacity() {
        int n = this.start < this.end || this.isEmpty ? this.bufferLen - this.end : this.start - this.end;
        return n;
    }

    public int fill(ReadableSource<A> source) throws IOException {
        int n;
        if (this.start < this.end || this.isEmpty) {
            int remainingSpace = this.bufferLen - this.end;
            n = source.read(this.buffer, this.end, remainingSpace);
        } else {
            int d = this.start - this.end;
            n = d == 0 ? 0 : source.read(this.buffer, this.end, d);
        }
        this.incEnd(n);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected void incEnd(int n) {
        if (n > 0) {
            this.end += n;
            this.isEmpty = false;
            if (this.end == this.bufferLen) {
                this.end = 0;
            } else if (this.end > this.bufferLen) {
                throw new IllegalStateException("Should not happen: End pointer exceeded buffer length");
            }
        }
    }

    public int available() {
        return this.bufferLen - this.capacity();
    }

    public int capacity() {
        return this.isEmpty ? this.bufferLen : (this.end > this.start ? this.bufferLen - this.end + this.start : this.start - this.end);
    }

    public int length() {
        return this.bufferLen;
    }

    public RingBufferBase<A> skip(int length) {
        int n = this.available();
        if (length > n) {
            throw new IllegalArgumentException("Requested skipping " + length + " elements but only " + n + " available.");
        }
        this.incStart(length);
        return this;
    }

    @Override
    public int read(A tgt, int tgtOffset, int length) throws IOException {
        int savedStart = this.start;
        int result = this.preRead(length);
        if (result > 0) {
            this.getArrayOps().copy(this.buffer, savedStart, tgt, tgtOffset, result);
        }
        return result;
    }

    protected int preRead(int length) {
        int result;
        if (this.start == this.end && this.isEmpty) {
            result = -1;
        } else {
            if (this.start < this.end) {
                int remainingSpace = this.end - this.start;
                result = Math.min(remainingSpace, length);
            } else {
                int remainingSpace = this.bufferLen - this.start;
                result = Math.min(remainingSpace, length);
            }
            this.incStart(result);
        }
        return result;
    }

    protected void incStart(int amount) {
        if (amount > 0) {
            this.start += amount;
            if (this.start == this.bufferLen) {
                this.start = 0;
            }
            if (this.start == this.end) {
                this.start = 0;
                this.end = 0;
                this.isEmpty = true;
            }
        }
    }

    public void resize(int newSize) {
        if (newSize < 1) {
            throw new IllegalArgumentException("Requested new size (" + newSize + ") must be at least 1");
        }
        int avail = this.available();
        if (newSize < avail) {
            throw new IllegalArgumentException("Requested new size (" + newSize + ") must be greater than or equal to the amount of available data (" + avail + ")");
        }
        Object newBuffer = this.getArrayOps().create(newSize);
        try {
            ReadableChannels.readFully(this, newBuffer, 0, avail);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen", e);
        }
        this.buffer = newBuffer;
        this.bufferLen = newSize;
        this.start = 0;
        this.end = avail;
        this.isEmpty = avail == 0;
    }
}

