/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.plain;

import java.io.IOException;
import java.util.AbstractList;
import org.aksw.commons.io.buffer.plain.Buffer;

public class ListOverBuffer<T>
extends AbstractList<T> {
    protected Buffer<?> buffer;
    protected int size;

    public ListOverBuffer(Buffer<?> buffer) {
        this(buffer, 0);
    }

    public ListOverBuffer(Buffer<?> buffer, int size) {
        this.buffer = buffer;
        this.size = size;
    }

    @Override
    public boolean add(T e) {
        this.set(this.size, e);
        ++this.size;
        return true;
    }

    @Override
    public T get(int index) {
        Object tmp;
        try {
            tmp = this.buffer.get(index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object result = tmp;
        return (T)result;
    }

    @Override
    public T set(int index, T element) {
        try {
            this.buffer.put(index, element);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return element;
    }

    @Override
    public int size() {
        return this.size;
    }
}

