/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.plain;

import com.google.common.math.LongMath;
import java.util.List;
import org.aksw.commons.io.buffer.array.BufferLike;
import org.aksw.commons.io.buffer.plain.ListOverBuffer;
import org.aksw.commons.io.buffer.plain.SubBufferImpl;

public interface Buffer<A>
extends BufferLike<A> {
    @Override
    default public Buffer<A> slice(long offset, long length) {
        if (LongMath.checkedAdd((long)offset, (long)length) > this.getCapacity()) {
            throw new RuntimeException("Sub-buffer extends over capacity of this buffer");
        }
        return new SubBufferImpl(this, offset, length);
    }

    default public <T> List<T> asList() {
        return new ListOverBuffer(this);
    }
}

