/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.impl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.Page;
import org.aksw.commons.io.block.impl.PageBase;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;

public class PageManagerWrapper
implements PageManager {
    protected PageManager delegate;
    protected long displacement;
    protected int virtPageSize;

    public PageManagerWrapper(PageManager delegate, long displacement, int pageSize) {
        this.delegate = delegate;
        this.displacement = displacement;
        this.virtPageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref<Page> requestBufferForPage(long page) {
        ByteBuffer resultBuffer;
        Ref<? extends Page> delegatePage;
        int physPageSize = this.delegate.getPageSize();
        long effPos = page * (long)this.virtPageSize - this.displacement;
        long effPage = effPos / (long)physPageSize;
        int effIndex = (int)effPos % physPageSize;
        long effEndPos = effPos + (long)this.virtPageSize;
        long effEndPage = effEndPos / (long)physPageSize;
        int effEndIndex = (int)effEndPos % physPageSize;
        if (effPage == effEndPage) {
            delegatePage = this.delegate.requestBufferForPage(effPage);
            ByteBuffer buf = ((Page)delegatePage.get()).newBuffer();
            if (buf == null) {
                resultBuffer = null;
            } else {
                int o = buf.position();
                resultBuffer = buf.duplicate();
                ((Buffer)resultBuffer).position(o + effIndex);
                ((Buffer)resultBuffer).limit(o + effEndIndex);
            }
        } else {
            byte[] cpy = new byte[this.virtPageSize];
            resultBuffer = ByteBuffer.wrap(cpy);
            long i = effPage;
            while (true) {
                delegatePage = this.delegate.requestBufferForPage(i);
                try {
                    ByteBuffer buf = ((Page)delegatePage.get()).newBuffer();
                    if (buf == null) break;
                    int o = buf.position();
                    buf = buf.duplicate();
                    int index = i == effPage ? effIndex : 0;
                    ((Buffer)buf).position(o + index);
                    int take = Math.min(buf.remaining(), resultBuffer.remaining());
                    ((Buffer)buf).limit(buf.position() + take);
                    resultBuffer.put(buf);
                    if (resultBuffer.remaining() == 0) {
                        ((Buffer)resultBuffer).position(0);
                        break;
                    }
                }
                finally {
                    try {
                        delegatePage.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
        }
        Ref<? extends Page> delPage = delegatePage;
        PageBase tmp = new PageBase(this, page, resultBuffer);
        Ref result = RefImpl.create((Object)tmp, null, () -> {
            if (delPage != null) {
                delPage.close();
            }
        }, null);
        return result;
    }

    @Override
    public int getPageSize() {
        return this.virtPageSize;
    }

    @Override
    public long getEndPos() {
        return this.delegate.getEndPos();
    }
}

