/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.cache.async.AsyncClaimingCacheImpl;
import org.aksw.commons.cache.plain.ClaimingCache;
import org.aksw.commons.cache.plain.ClaimingCacheOverAsync;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.Page;
import org.aksw.commons.io.block.impl.PageBase;
import org.aksw.commons.io.input.ReadableByteChannelAdapter;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.util.range.PageHelper;
import org.aksw.commons.util.ref.Ref;
import org.apache.commons.io.IOUtils;

public class PageManagerOverDataStreamSource
implements PageManager {
    protected ReadableChannelSource<byte[]> source;
    protected int pageSize;
    protected ClaimingCache<Long, Page> pageCache;
    protected long sourceSize;
    protected long lastPageId;

    public PageManagerOverDataStreamSource(ReadableChannelSource<byte[]> source, int pageSize, AsyncClaimingCacheImpl.Builder<Long, Page> cacheBuilder) {
        this.source = source;
        this.pageSize = pageSize;
        try {
            this.sourceSize = source.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastPageId = PageHelper.getLastPageId((long)this.sourceSize, (long)pageSize);
        this.pageCache = ClaimingCacheOverAsync.wrap((AsyncClaimingCache)cacheBuilder.setCacheLoader(this::loadPage).build());
    }

    @Override
    public Ref<? extends Page> requestBufferForPage(long pageId) {
        return this.pageCache.claim((Object)pageId);
    }

    public Page loadPage(long pageId) {
        PageBase result;
        Preconditions.checkArgument((pageId >= 0L && pageId <= this.lastPageId ? 1 : 0) != 0, (String)"PageId %s out of bounds", (long)pageId);
        long offset = PageHelper.getPageOffsetForPageId((long)pageId, (long)this.pageSize);
        int effectivePageSize = pageId != this.lastPageId ? this.pageSize : (int)(this.sourceSize % (long)this.pageSize);
        try (ReadableByteChannelAdapter channel = ReadableChannels.newChannel(this.source.newReadableChannel((Range<Long>)Range.closedOpen((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(offset + (long)effectivePageSize))));){
            ByteBuffer buffer = ByteBuffer.allocate(effectivePageSize);
            ByteBuffer dup = buffer.duplicate();
            IOUtils.read(channel, (ByteBuffer)dup);
            result = new PageBase(this, pageId, buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getEndPos() {
        return this.sourceSize;
    }
}

