/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.Page;
import org.aksw.commons.io.block.impl.PageBase;
import org.aksw.commons.io.nio.ChannelUtils;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;

public class PageManagerForFileChannel
implements PageManager {
    public static final int DEFAULT_PAGE_SIZE = 0x1000000;
    protected Cache<Long, Ref<Page>> pageCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).maximumSize(64L).removalListener(notification -> {
        try {
            ((Ref)notification.getValue()).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }).build();
    protected FileChannel channel;
    protected long channelSize;
    protected int pageSize;

    public PageManagerForFileChannel(FileChannel channel, long channelSize, int pageSize) {
        this.channel = channel;
        this.channelSize = channelSize;
        this.pageSize = pageSize;
    }

    public static PageManagerForFileChannel create(FileChannel channel) throws IOException {
        return PageManagerForFileChannel.create(channel, 0x1000000);
    }

    public static PageManagerForFileChannel create(FileChannel channel, int pageSize) throws IOException {
        long size = channel.size();
        return new PageManagerForFileChannel(channel, size, pageSize);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public Ref<Page> requestBufferForPage(long page) {
        Ref<Page> result;
        try {
            result = this.getRefForPage(page);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static ByteBuffer map(FileChannel channel, FileChannel.MapMode mapMode, long start, long length) throws IOException {
        ByteBuffer result;
        try {
            result = channel.map(mapMode, start, length);
        }
        catch (UnsupportedOperationException e) {
            if (!FileChannel.MapMode.READ_ONLY.equals(mapMode)) {
                throw new UnsupportedOperationException("The fallback for file channels without 'map' support requires MapMode.READ_ONLY", e);
            }
            int l = Ints.saturatedCast((long)length);
            result = ByteBuffer.allocate(l);
            int n = ChannelUtils.readFully((SeekableByteChannel)channel, (ByteBuffer)result, (long)start);
            result.position(0);
            result.limit(Math.max(0, n));
        }
        return result;
    }

    public synchronized Ref<Page> getRefForPage(long page) throws IOException {
        Ref parentRef;
        long start = page * (long)this.pageSize;
        long end = Math.min(this.channelSize, start + (long)this.pageSize);
        long length = end - start;
        try {
            parentRef = page < 0L || length <= 0L ? null : (Ref)this.pageCache.get((Object)page, () -> {
                ByteBuffer b = PageManagerForFileChannel.map(this.channel, FileChannel.MapMode.READ_ONLY, start, length);
                PageBase p = new PageBase(this, page, b);
                Ref r = RefImpl.create((Object)p, null, () -> {}, (Object)("Primary ref to page " + page));
                return r;
            });
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        Ref result = parentRef == null ? null : parentRef.acquire((Object)("Secondary ref to page " + page));
        return result;
    }

    @Override
    public long getEndPos() {
        return this.channelSize;
    }
}

